package physx.support;

import physx.NativeObject;

public class SimplePvdTransport extends PxPvdTransport {

    protected SimplePvdTransport() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static SimplePvdTransport wrapPointer(long address) {
        return address != 0L ? new SimplePvdTransport(address) : null;
    }
    
    public static SimplePvdTransport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected SimplePvdTransport(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param inBytes  WebIDL type: any
     * @param inLength WebIDL type: unsigned long
     */
    public void send(NativeObject inBytes, int inLength) {
        checkNotNull();
        _send(address, inBytes.getAddress(), inLength);
    }
    private static native void _send(long address, long inBytes, int inLength);

}
