package physx.support;

import physx.NativeObject;

public class PxOmniPvd extends NativeObject {

    protected PxOmniPvd() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxOmniPvd wrapPointer(long address) {
        return address != 0L ? new PxOmniPvd(address) : null;
    }
    
    public static PxOmniPvd arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxOmniPvd(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * Gets an instance of the OmniPvd writer
     * @return OmniPvdWriter instance on succes, NULL otherwise.
     */
    public OmniPvdWriter getWriter() {
        checkNotNull();
        return OmniPvdWriter.wrapPointer(_getWriter(address));
    }
    private static native long _getWriter(long address);

    /**
     * Gets an instance to the OmniPvd file write stream
     * @return OmniPvdFileWriteStream instance on succes, NULL otherwise.
     */
    public OmniPvdFileWriteStream getFileWriteStream() {
        checkNotNull();
        return OmniPvdFileWriteStream.wrapPointer(_getFileWriteStream(address));
    }
    private static native long _getFileWriteStream(long address);

    /**
     * Starts the OmniPvd sampling
     * @return True if sampling started correctly, false if not.
     */
    public boolean startSampling() {
        checkNotNull();
        return _startSampling(address);
    }
    private static native boolean _startSampling(long address);

    /**
     * Releases the PxOmniPvd object
     */
    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

}
