package physx.physics;

/**
 * Enum for selecting the type of solver used for the simulation.
 * <p>
 * #PxSolverType::ePGS selects the iterative sequential impulse solver. This is the same kind of solver used in PhysX 3.4 and earlier releases.
 * <p>
 * #PxSolverType::eTGS selects a non linear iterative solver. This kind of solver can lead to improved convergence and handle large mass ratios, long chains and jointed systems better. It is slightly more expensive than the default solver and can introduce more energy to correct joint and contact errors.
 */
public enum PxSolverTypeEnum {

    /**
     * Projected Gauss-Seidel iterative solver
     */
    ePGS(getePGS()),
    eTGS(geteTGS());
    public final int value;
    
    PxSolverTypeEnum(int value) {
        this.value = value;
    }

    private static native int _getePGS();
    private static int getePGS() {
        de.fabmax.physxjni.Loader.load();
        return _getePGS();
    }

    private static native int _geteTGS();
    private static int geteTGS() {
        de.fabmax.physxjni.Loader.load();
        return _geteTGS();
    }

    public static PxSolverTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxSolverTypeEnum: " + value);
    }

}
