package physx.physics;

/**
 * Identifies the solver to use for a particle system.
 */
public enum PxParticleSolverTypeEnum {

    /**
     * The position based dynamics solver that can handle fluid, granular material, cloth, inflatables etc. See #PxPBDParticleSystem.
     */
    ePBD(getePBD()),
    /**
     * The FLIP fluid solver. See #PxFLIPParticleSystem.
     */
    eFLIP(geteFLIP()),
    /**
     * The MPM (material point method) solver that can handle a variety of materials. See #PxMPMParticleSystem.
     */
    eMPM(geteMPM()),
    eCUSTOM(geteCUSTOM());
    public final int value;
    
    PxParticleSolverTypeEnum(int value) {
        this.value = value;
    }

    private static native int _getePBD();
    private static int getePBD() {
        de.fabmax.physxjni.Loader.load();
        return _getePBD();
    }

    private static native int _geteFLIP();
    private static int geteFLIP() {
        de.fabmax.physxjni.Loader.load();
        return _geteFLIP();
    }

    private static native int _geteMPM();
    private static int geteMPM() {
        de.fabmax.physxjni.Loader.load();
        return _geteMPM();
    }

    private static native int _geteCUSTOM();
    private static int geteCUSTOM() {
        de.fabmax.physxjni.Loader.load();
        return _geteCUSTOM();
    }

    public static PxParticleSolverTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxParticleSolverTypeEnum: " + value);
    }

}
