package physx.physics;

public enum PxArticulationFlagEnum {

    /**
     * Set articulation base to be fixed.
     */
    eFIX_BASE(geteFIX_BASE()),
    /**
     * Limits for drive effort are forces and torques rather than impulses, see PxArticulationDrive::maxForce.
     */
    eDRIVE_LIMITS_ARE_FORCES(geteDRIVE_LIMITS_ARE_FORCES()),
    /**
     * Disable collisions between the articulation's links (note that parent/child collisions are disabled internally in either case).
     */
    eDISABLE_SELF_COLLISION(geteDISABLE_SELF_COLLISION()),
    eCOMPUTE_JOINT_FORCES(geteCOMPUTE_JOINT_FORCES());
    public final int value;
    
    PxArticulationFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteFIX_BASE();
    private static int geteFIX_BASE() {
        de.fabmax.physxjni.Loader.load();
        return _geteFIX_BASE();
    }

    private static native int _geteDRIVE_LIMITS_ARE_FORCES();
    private static int geteDRIVE_LIMITS_ARE_FORCES() {
        de.fabmax.physxjni.Loader.load();
        return _geteDRIVE_LIMITS_ARE_FORCES();
    }

    private static native int _geteDISABLE_SELF_COLLISION();
    private static int geteDISABLE_SELF_COLLISION() {
        de.fabmax.physxjni.Loader.load();
        return _geteDISABLE_SELF_COLLISION();
    }

    private static native int _geteCOMPUTE_JOINT_FORCES();
    private static int geteCOMPUTE_JOINT_FORCES() {
        de.fabmax.physxjni.Loader.load();
        return _geteCOMPUTE_JOINT_FORCES();
    }

    public static PxArticulationFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationFlagEnum: " + value);
    }

}
