package physx.geometry;


/**
 * Custom geometry class. This class allows user to create custom geometries by providing a set of virtual callback functions.
 */
public class PxCustomGeometry extends PxGeometry {

    protected PxCustomGeometry() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCustomGeometry wrapPointer(long address) {
        return address != 0L ? new PxCustomGeometry(address) : null;
    }
    
    public static PxCustomGeometry arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCustomGeometry(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param callbacks WebIDL type: {@link SimpleCustomGeometryCallbacks} [Ref]
     */
    public PxCustomGeometry(SimpleCustomGeometryCallbacks callbacks) {
        address = _PxCustomGeometry(callbacks.getAddress());
    }
    private static native long _PxCustomGeometry(long callbacks);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
