package physx.geometry;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxContactBuffer extends NativeObject {

    protected PxContactBuffer() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxContactBuffer wrapPointer(long address) {
        return address != 0L ? new PxContactBuffer(address) : null;
    }
    
    public static PxContactBuffer arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxContactBuffer(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxContactPoint} [Value]
     */
    public PxContactPoint getContacts(int index) {
        checkNotNull();
        return PxContactPoint.wrapPointer(_getContacts(address, index));
    }
    private static native long _getContacts(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxContactPoint} [Value]
     */
    public void setContacts(int index, PxContactPoint value) {
        checkNotNull();
        _setContacts(address, index, value.getAddress());
    }
    private static native void _setContacts(long address, int index, long value);

    /**
     */
    public int getCount() {
        checkNotNull();
        return _getCount(address);
    }
    private static native int _getCount(long address);

    /**
     */
    public void setCount(int value) {
        checkNotNull();
        _setCount(address, value);
    }
    private static native void _setCount(long address, int value);

    /**
     */
    public int getPad() {
        checkNotNull();
        return _getPad(address);
    }
    private static native int _getPad(long address);

    /**
     */
    public void setPad(int value) {
        checkNotNull();
        _setPad(address, value);
    }
    private static native void _setPad(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public static int getMAX_CONTACTS() {
        return _getMAX_CONTACTS();
    }
    private static native int _getMAX_CONTACTS();

    // Functions

    public void reset() {
        checkNotNull();
        _reset(address);
    }
    private static native void _reset(long address);

    /**
     * @param worldPoint    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param worldNormalIn WebIDL type: {@link PxVec3} [Const, Ref]
     * @param separation    WebIDL type: float
     * @return WebIDL type: boolean
     */
    public boolean contact(PxVec3 worldPoint, PxVec3 worldNormalIn, float separation) {
        checkNotNull();
        return _contact(address, worldPoint.getAddress(), worldNormalIn.getAddress(), separation);
    }
    private static native boolean _contact(long address, long worldPoint, long worldNormalIn, float separation);

    /**
     * @param worldPoint    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param worldNormalIn WebIDL type: {@link PxVec3} [Const, Ref]
     * @param separation    WebIDL type: float
     * @param faceIndex1    WebIDL type: unsigned long
     * @return WebIDL type: boolean
     */
    public boolean contact(PxVec3 worldPoint, PxVec3 worldNormalIn, float separation, int faceIndex1) {
        checkNotNull();
        return _contact(address, worldPoint.getAddress(), worldNormalIn.getAddress(), separation, faceIndex1);
    }
    private static native boolean _contact(long address, long worldPoint, long worldNormalIn, float separation, int faceIndex1);

    /**
     * @param pt WebIDL type: {@link PxContactPoint} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean contact(PxContactPoint pt) {
        checkNotNull();
        return _contact(address, pt.getAddress());
    }
    private static native boolean _contact(long address, long pt);

    /**
     * @return WebIDL type: {@link PxContactPoint} [Platforms=windows;linux;macos]
     */
    public PxContactPoint contact() {
        checkNotNull();
        return PxContactPoint.wrapPointer(_contact(address));
    }
    private static native long _contact(long address);

}
