package physx.common;

import physx.NativeObject;

public class PxCudaTopLevelFunctions extends NativeObject {

    protected PxCudaTopLevelFunctions() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCudaTopLevelFunctions wrapPointer(long address) {
        return address != 0L ? new PxCudaTopLevelFunctions(address) : null;
    }
    
    public static PxCudaTopLevelFunctions arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCudaTopLevelFunctions(long address) {
        super(address);
    }

    // Functions

    /**
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @param desc       WebIDL type: {@link PxCudaContextManagerDesc} [Const, Ref]
     * @return WebIDL type: {@link PxCudaContextManager}
     */
    public static PxCudaContextManager CreateCudaContextManager(PxFoundation foundation, PxCudaContextManagerDesc desc) {
        return PxCudaContextManager.wrapPointer(_CreateCudaContextManager(foundation.getAddress(), desc.getAddress()));
    }
    private static native long _CreateCudaContextManager(long foundation, long desc);

}
