package physx.character;


/**
 * A descriptor for a capsule character controller.
 * @see PxCapsuleController
 * @see PxControllerDesc
 */
public class PxCapsuleControllerDesc extends PxControllerDesc {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCapsuleControllerDesc wrapPointer(long address) {
        return address != 0L ? new PxCapsuleControllerDesc(address) : null;
    }
    
    public static PxCapsuleControllerDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCapsuleControllerDesc(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxCapsuleControllerDesc
     */
    public static PxCapsuleControllerDesc createAt(long address) {
        __placement_new_PxCapsuleControllerDesc(address);
        PxCapsuleControllerDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxCapsuleControllerDesc
     */
    public static <T> PxCapsuleControllerDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxCapsuleControllerDesc(address);
        PxCapsuleControllerDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxCapsuleControllerDesc(long address);

    // Constructors

    /**
     * constructor sets to default.
     */
    public PxCapsuleControllerDesc() {
        address = _PxCapsuleControllerDesc();
    }
    private static native long _PxCapsuleControllerDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The radius of the capsule
     * <p>
     * <b>Default:</b> 0.0
     * @see PxCapsuleController
     */
    public float getRadius() {
        checkNotNull();
        return _getRadius(address);
    }
    private static native float _getRadius(long address);

    /**
     * The radius of the capsule
     * <p>
     * <b>Default:</b> 0.0
     * @see PxCapsuleController
     */
    public void setRadius(float value) {
        checkNotNull();
        _setRadius(address, value);
    }
    private static native void _setRadius(long address, float value);

    /**
     * The height of the controller
     * <p>
     * <b>Default:</b> 0.0
     * @see PxCapsuleController
     */
    public float getHeight() {
        checkNotNull();
        return _getHeight(address);
    }
    private static native float _getHeight(long address);

    /**
     * The height of the controller
     * <p>
     * <b>Default:</b> 0.0
     * @see PxCapsuleController
     */
    public void setHeight(float value) {
        checkNotNull();
        _setHeight(address, value);
    }
    private static native void _setHeight(long address, float value);

    /**
     * The climbing mode
     * <p>
     * <b>Default:</b> PxCapsuleClimbingMode::eEASY
     * @see PxCapsuleController
     */
    public PxCapsuleClimbingModeEnum getClimbingMode() {
        checkNotNull();
        return PxCapsuleClimbingModeEnum.forValue(_getClimbingMode(address));
    }
    private static native int _getClimbingMode(long address);

    /**
     * The climbing mode
     * <p>
     * <b>Default:</b> PxCapsuleClimbingMode::eEASY
     * @see PxCapsuleController
     */
    public void setClimbingMode(PxCapsuleClimbingModeEnum value) {
        checkNotNull();
        _setClimbingMode(address, value.value);
    }
    private static native void _setClimbingMode(long address, int value);

    // Functions

    /**
     * (re)sets the structure to the default.
     */
    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
