package physx.character;


/**
 * Descriptor for a box character controller.
 * @see PxBoxController
 * @see PxControllerDesc
 */
public class PxBoxControllerDesc extends PxControllerDesc {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBoxControllerDesc wrapPointer(long address) {
        return address != 0L ? new PxBoxControllerDesc(address) : null;
    }
    
    public static PxBoxControllerDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBoxControllerDesc(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxBoxControllerDesc
     */
    public static PxBoxControllerDesc createAt(long address) {
        __placement_new_PxBoxControllerDesc(address);
        PxBoxControllerDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxBoxControllerDesc
     */
    public static <T> PxBoxControllerDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxBoxControllerDesc(address);
        PxBoxControllerDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxBoxControllerDesc(long address);

    // Constructors

    /**
     * constructor sets to default.
     */
    public PxBoxControllerDesc() {
        address = _PxBoxControllerDesc();
    }
    private static native long _PxBoxControllerDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Half height
     * <p>
     * <b>Default:</b> 1.0
     */
    public float getHalfHeight() {
        checkNotNull();
        return _getHalfHeight(address);
    }
    private static native float _getHalfHeight(long address);

    /**
     * Half height
     * <p>
     * <b>Default:</b> 1.0
     */
    public void setHalfHeight(float value) {
        checkNotNull();
        _setHalfHeight(address, value);
    }
    private static native void _setHalfHeight(long address, float value);

    /**
     * Half side extent
     * <p>
     * <b>Default:</b> 0.5
     */
    public float getHalfSideExtent() {
        checkNotNull();
        return _getHalfSideExtent(address);
    }
    private static native float _getHalfSideExtent(long address);

    /**
     * Half side extent
     * <p>
     * <b>Default:</b> 0.5
     */
    public void setHalfSideExtent(float value) {
        checkNotNull();
        _setHalfSideExtent(address, value);
    }
    private static native void _setHalfSideExtent(long address, float value);

    /**
     * Half forward extent
     * <p>
     * <b>Default:</b> 0.5
     */
    public float getHalfForwardExtent() {
        checkNotNull();
        return _getHalfForwardExtent(address);
    }
    private static native float _getHalfForwardExtent(long address);

    /**
     * Half forward extent
     * <p>
     * <b>Default:</b> 0.5
     */
    public void setHalfForwardExtent(float value) {
        checkNotNull();
        _setHalfForwardExtent(address, value);
    }
    private static native void _setHalfForwardExtent(long address, float value);

    // Functions

    /**
     * (re)sets the structure to the default.
     */
    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
