/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle;

import physx.NativeObject;

public class PxVehicleWheelsDynData
extends NativeObject {
    protected PxVehicleWheelsDynData() {
    }

    public static PxVehicleWheelsDynData wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheelsDynData(address) : null;
    }

    protected PxVehicleWheelsDynData(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        PxVehicleWheelsDynData._delete_native_instance(this.address);
        this.address = 0L;
    }

    private static native long _delete_native_instance(long var0);

    public void setToRestState() {
        this.checkNotNull();
        PxVehicleWheelsDynData._setToRestState(this.address);
    }

    private static native void _setToRestState(long var0);

    public void setWheelRotationSpeed(int wheelIdx, float speed) {
        this.checkNotNull();
        PxVehicleWheelsDynData._setWheelRotationSpeed(this.address, wheelIdx, speed);
    }

    private static native void _setWheelRotationSpeed(long var0, int var2, float var3);

    public float getWheelRotationSpeed(int wheelIdx) {
        this.checkNotNull();
        return PxVehicleWheelsDynData._getWheelRotationSpeed(this.address, wheelIdx);
    }

    private static native float _getWheelRotationSpeed(long var0, int var2);

    public void setWheelRotationAngle(int wheelIdx, float angle) {
        this.checkNotNull();
        PxVehicleWheelsDynData._setWheelRotationAngle(this.address, wheelIdx, angle);
    }

    private static native void _setWheelRotationAngle(long var0, int var2, float var3);

    public float getWheelRotationAngle(int wheelIdx) {
        this.checkNotNull();
        return PxVehicleWheelsDynData._getWheelRotationAngle(this.address, wheelIdx);
    }

    private static native float _getWheelRotationAngle(long var0, int var2);

    public void copy(PxVehicleWheelsDynData src, int srcWheel, int trgWheel) {
        this.checkNotNull();
        PxVehicleWheelsDynData._copy(this.address, src.getAddress(), srcWheel, trgWheel);
    }

    private static native void _copy(long var0, long var2, int var4, int var5);

    public int getNbWheelRotationSpeed() {
        this.checkNotNull();
        return PxVehicleWheelsDynData._getNbWheelRotationSpeed(this.address);
    }

    private static native int _getNbWheelRotationSpeed(long var0);

    public int getNbWheelRotationAngle() {
        this.checkNotNull();
        return PxVehicleWheelsDynData._getNbWheelRotationAngle(this.address);
    }

    private static native int _getNbWheelRotationAngle(long var0);
}

