/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.physxjni;

public enum Platform {
    LINUX("de.fabmax.physxjni.NativeMetaLinux"),
    WINDOWS("de.fabmax.physxjni.NativeMetaWindows"),
    MACOS("de.fabmax.physxjni.NativeMetaMacos");

    private final String metaClassName;

    private Platform(String metaClassName) {
        this.metaClassName = metaClassName;
    }

    public String getMetaClassName() {
        return this.metaClassName;
    }

    public static Platform getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            return WINDOWS;
        }
        if (osName.contains("linux")) {
            return LINUX;
        }
        if (osName.contains("mac os x") || osName.contains("darwin") || osName.contains("osx")) {
            return MACOS;
        }
        throw new IllegalStateException("Unsupported OS: " + osName);
    }
}

