package physx.vehicle;


public class PxVehicleDriveSimDataNW extends PxVehicleDriveSimData {

    public static PxVehicleDriveSimDataNW wrapPointer(long address) {
        return address != 0L ? new PxVehicleDriveSimDataNW(address) : null;
    }
    
    protected PxVehicleDriveSimDataNW(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleDriveSimDataNW() {
        address = _PxVehicleDriveSimDataNW();
    }
    private static native long _PxVehicleDriveSimDataNW();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: {@link PxVehicleDifferentialNWData} [Const, Ref]
     */
    public PxVehicleDifferentialNWData getDiffData() {
        checkNotNull();
        return PxVehicleDifferentialNWData.wrapPointer(_getDiffData(address));
    }
    private static native long _getDiffData(long address);

    /**
     * @param diff WebIDL type: {@link PxVehicleDifferentialNWData} [Const, Ref]
     */
    public void setDiffData(PxVehicleDifferentialNWData diff) {
        checkNotNull();
        _setDiffData(address, diff.getAddress());
    }
    private static native void _setDiffData(long address, long diff);

}
