package physx.vehicle;

import physx.NativeObject;

public class PxVehicleDifferentialNWData extends NativeObject {

    public static PxVehicleDifferentialNWData wrapPointer(long address) {
        return address != 0L ? new PxVehicleDifferentialNWData(address) : null;
    }
    
    protected PxVehicleDifferentialNWData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleDifferentialNWData() {
        address = _PxVehicleDifferentialNWData();
    }
    private static native long _PxVehicleDifferentialNWData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param wheelId     WebIDL type: unsigned long
     * @param drivenState WebIDL type: boolean
     */
    public void setDrivenWheel(int wheelId, boolean drivenState) {
        checkNotNull();
        _setDrivenWheel(address, wheelId, drivenState);
    }
    private static native void _setDrivenWheel(long address, int wheelId, boolean drivenState);

    /**
     * @param wheelId WebIDL type: unsigned long
     * @return WebIDL type: boolean
     */
    public boolean getIsDrivenWheel(int wheelId) {
        checkNotNull();
        return _getIsDrivenWheel(address, wheelId);
    }
    private static native boolean _getIsDrivenWheel(long address, int wheelId);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getDrivenWheelStatus() {
        checkNotNull();
        return _getDrivenWheelStatus(address);
    }
    private static native int _getDrivenWheelStatus(long address);

    /**
     * @param status WebIDL type: unsigned long
     */
    public void setDrivenWheelStatus(int status) {
        checkNotNull();
        _setDrivenWheelStatus(address, status);
    }
    private static native void _setDrivenWheelStatus(long address, int status);

}
