package physx.support;

import physx.NativeObject;
import physx.vehicle.PxWheelQueryResult;

public class Vector_PxWheelQueryResult extends NativeObject {

    public static Vector_PxWheelQueryResult wrapPointer(long address) {
        return address != 0L ? new Vector_PxWheelQueryResult(address) : null;
    }
    
    protected Vector_PxWheelQueryResult(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxWheelQueryResult() {
        address = _Vector_PxWheelQueryResult();
    }
    private static native long _Vector_PxWheelQueryResult();

    /**
     * @param size WebIDL type: unsigned long
     */
    public Vector_PxWheelQueryResult(int size) {
        address = _Vector_PxWheelQueryResult(size);
    }
    private static native long _Vector_PxWheelQueryResult(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxWheelQueryResult} [Ref]
     */
    public PxWheelQueryResult at(int index) {
        checkNotNull();
        return PxWheelQueryResult.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return WebIDL type: {@link PxWheelQueryResult}
     */
    public PxWheelQueryResult data() {
        checkNotNull();
        return PxWheelQueryResult.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxWheelQueryResult} [Ref]
     */
    public void push_back(PxWheelQueryResult value) {
        checkNotNull();
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
