package physx.support;

import physx.NativeObject;
import physx.physics.PxActor;
import physx.physics.PxContactPairHeader;
import physx.physics.PxRigidActor;
import physx.physics.PxScene;
import physx.physics.PxShape;

public class SupportFunctions extends NativeObject {

    protected SupportFunctions() { }

    public static SupportFunctions wrapPointer(long address) {
        return address != 0L ? new SupportFunctions(address) : null;
    }
    
    protected SupportFunctions(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param actor WebIDL type: {@link PxRigidActor} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxShape}
     */
    public static PxShape PxActor_getShape(PxRigidActor actor, int index) {
        return PxShape.wrapPointer(_PxActor_getShape(actor.getAddress(), index));
    }
    private static native long _PxActor_getShape(long actor, int index);

    /**
     * @param pairHeader WebIDL type: {@link PxContactPairHeader} [Ref]
     * @param index      WebIDL type: long
     * @return WebIDL type: {@link PxActor}
     */
    public static PxActor PxContactPairHeader_getActor(PxContactPairHeader pairHeader, int index) {
        return PxActor.wrapPointer(_PxContactPairHeader_getActor(pairHeader.getAddress(), index));
    }
    private static native long _PxContactPairHeader_getActor(long pairHeader, int index);

    /**
     * @param scene WebIDL type: {@link PxScene}
     * @return WebIDL type: {@link Vector_PxActorPtr} [Ref]
     */
    public static Vector_PxActorPtr PxScene_getActiveActors(PxScene scene) {
        return Vector_PxActorPtr.wrapPointer(_PxScene_getActiveActors(scene.getAddress()));
    }
    private static native long _PxScene_getActiveActors(long scene);

}
