package physx.support;

import physx.NativeObject;

public class PxPvdInstrumentationFlags extends NativeObject {

    protected PxPvdInstrumentationFlags() { }

    public static PxPvdInstrumentationFlags wrapPointer(long address) {
        return address != 0L ? new PxPvdInstrumentationFlags(address) : null;
    }
    
    protected PxPvdInstrumentationFlags(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param flags WebIDL type: octet
     */
    public PxPvdInstrumentationFlags(byte flags) {
        address = _PxPvdInstrumentationFlags(flags);
    }
    private static native long _PxPvdInstrumentationFlags(byte flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxPvdInstrumentationFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(int flag) {
        checkNotNull();
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxPvdInstrumentationFlagEnum} [enum]
     */
    public void set(int flag) {
        checkNotNull();
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxPvdInstrumentationFlagEnum} [enum]
     */
    public void clear(int flag) {
        checkNotNull();
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
