package physx.support;

import physx.NativeObject;

public class JSPvdTransport extends SimplePvdTransport {

    public static JSPvdTransport wrapPointer(long address) {
        return address != 0L ? new JSPvdTransport(address) : null;
    }
    
    protected JSPvdTransport(long address) {
        super(address);
    }

    protected JSPvdTransport() {
        address = _JSPvdTransport();
    }
    private native long _JSPvdTransport();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private boolean _connect() {
        return connect();
    }

    /**
     * @return WebIDL type: boolean
     */
    public boolean connect() {
        return false;
    }

    /*
     * Called from native code
     */
    private void _send(long inBytes, int inLength) {
        send(NativeObject.wrapPointer(inBytes), inLength);
    }

    /**
     * @param inBytes  WebIDL type: any
     * @param inLength WebIDL type: unsigned long
     */
    public void send(NativeObject inBytes, int inLength) { }

}
