package physx.physics;


public class PxRaycastHit extends PxLocationHit {

    public static PxRaycastHit wrapPointer(long address) {
        return address != 0L ? new PxRaycastHit(address) : null;
    }
    
    protected PxRaycastHit(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxRaycastHit
     */
    public static PxRaycastHit createAt(long address) {
        __placement_new_PxRaycastHit(address);
        PxRaycastHit createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxRaycastHit
     */
    public static <T> PxRaycastHit createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxRaycastHit(address);
        PxRaycastHit createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxRaycastHit(long address);

    // Constructors

    public PxRaycastHit() {
        address = _PxRaycastHit();
    }
    private static native long _PxRaycastHit();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getU() {
        checkNotNull();
        return _getU(address);
    }
    private static native float _getU(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setU(float value) {
        checkNotNull();
        _setU(address, value);
    }
    private static native void _setU(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getV() {
        checkNotNull();
        return _getV(address);
    }
    private static native float _getV(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setV(float value) {
        checkNotNull();
        _setV(address, value);
    }
    private static native void _setV(long address, float value);

}
