package physx.physics;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxContactPairPoint extends NativeObject {

    protected PxContactPairPoint() { }

    public static PxContactPairPoint wrapPointer(long address) {
        return address != 0L ? new PxContactPairPoint(address) : null;
    }
    
    protected PxContactPairPoint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getPosition() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPosition(address));
    }
    private static native long _getPosition(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setPosition(PxVec3 value) {
        checkNotNull();
        _setPosition(address, value.getAddress());
    }
    private static native void _setPosition(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getSeparation() {
        checkNotNull();
        return _getSeparation(address);
    }
    private static native float _getSeparation(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setSeparation(float value) {
        checkNotNull();
        _setSeparation(address, value);
    }
    private static native void _setSeparation(long address, float value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getNormal() {
        checkNotNull();
        return PxVec3.wrapPointer(_getNormal(address));
    }
    private static native long _getNormal(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setNormal(PxVec3 value) {
        checkNotNull();
        _setNormal(address, value.getAddress());
    }
    private static native void _setNormal(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getInternalFaceIndex0() {
        checkNotNull();
        return _getInternalFaceIndex0(address);
    }
    private static native int _getInternalFaceIndex0(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setInternalFaceIndex0(int value) {
        checkNotNull();
        _setInternalFaceIndex0(address, value);
    }
    private static native void _setInternalFaceIndex0(long address, int value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getImpulse() {
        checkNotNull();
        return PxVec3.wrapPointer(_getImpulse(address));
    }
    private static native long _getImpulse(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setImpulse(PxVec3 value) {
        checkNotNull();
        _setImpulse(address, value.getAddress());
    }
    private static native void _setImpulse(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getInternalFaceIndex1() {
        checkNotNull();
        return _getInternalFaceIndex1(address);
    }
    private static native int _getInternalFaceIndex1(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setInternalFaceIndex1(int value) {
        checkNotNull();
        _setInternalFaceIndex1(address, value);
    }
    private static native void _setInternalFaceIndex1(long address, int value);

}
