package physx.physics;

import physx.NativeObject;
import physx.common.PxBounds3;

public class PxBroadPhaseRegion extends NativeObject {

    public static PxBroadPhaseRegion wrapPointer(long address) {
        return address != 0L ? new PxBroadPhaseRegion(address) : null;
    }
    
    protected PxBroadPhaseRegion(long address) {
        super(address);
    }

    // Constructors

    public PxBroadPhaseRegion() {
        address = _PxBroadPhaseRegion();
    }
    private static native long _PxBroadPhaseRegion();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getBounds() {
        checkNotNull();
        return PxBounds3.wrapPointer(_getBounds(address));
    }
    private static native long _getBounds(long address);

    /**
     * @param value WebIDL type: {@link PxBounds3} [Value]
     */
    public void setBounds(PxBounds3 value) {
        checkNotNull();
        _setBounds(address, value.getAddress());
    }
    private static native void _setBounds(long address, long value);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject value) {
        checkNotNull();
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

}
