package physx.physics;

import physx.NativeObject;

public class PxBroadPhaseCaps extends NativeObject {

    public static PxBroadPhaseCaps wrapPointer(long address) {
        return address != 0L ? new PxBroadPhaseCaps(address) : null;
    }
    
    protected PxBroadPhaseCaps(long address) {
        super(address);
    }

    // Constructors

    public PxBroadPhaseCaps() {
        address = _PxBroadPhaseCaps();
    }
    private static native long _PxBroadPhaseCaps();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbRegions() {
        checkNotNull();
        return _getMaxNbRegions(address);
    }
    private static native int _getMaxNbRegions(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbRegions(int value) {
        checkNotNull();
        _setMaxNbRegions(address, value);
    }
    private static native void _setMaxNbRegions(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbObjects() {
        checkNotNull();
        return _getMaxNbObjects(address);
    }
    private static native int _getMaxNbObjects(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbObjects(int value) {
        checkNotNull();
        _setMaxNbObjects(address, value);
    }
    private static native void _setMaxNbObjects(long address, int value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getNeedsPredefinedBounds() {
        checkNotNull();
        return _getNeedsPredefinedBounds(address);
    }
    private static native boolean _getNeedsPredefinedBounds(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setNeedsPredefinedBounds(boolean value) {
        checkNotNull();
        _setNeedsPredefinedBounds(address, value);
    }
    private static native void _setNeedsPredefinedBounds(long address, boolean value);

}
