package physx.physics;

import physx.common.PxVec3;

public class PxArticulation extends PxArticulationBase {

    protected PxArticulation() { }

    public static PxArticulation wrapPointer(long address) {
        return address != 0L ? new PxArticulation(address) : null;
    }
    
    protected PxArticulation(long address) {
        super(address);
    }

    // Functions

    /**
     * @param iterations WebIDL type: unsigned long
     */
    public void setMaxProjectionIterations(int iterations) {
        checkNotNull();
        _setMaxProjectionIterations(address, iterations);
    }
    private static native void _setMaxProjectionIterations(long address, int iterations);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxProjectionIterations() {
        checkNotNull();
        return _getMaxProjectionIterations(address);
    }
    private static native int _getMaxProjectionIterations(long address);

    /**
     * @param tolerance WebIDL type: float
     */
    public void setSeparationTolerance(float tolerance) {
        checkNotNull();
        _setSeparationTolerance(address, tolerance);
    }
    private static native void _setSeparationTolerance(long address, float tolerance);

    /**
     * @return WebIDL type: float
     */
    public float getSeparationTolerance() {
        checkNotNull();
        return _getSeparationTolerance(address);
    }
    private static native float _getSeparationTolerance(long address);

    /**
     * @param iterations WebIDL type: unsigned long
     */
    public void setInternalDriveIterations(int iterations) {
        checkNotNull();
        _setInternalDriveIterations(address, iterations);
    }
    private static native void _setInternalDriveIterations(long address, int iterations);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getInternalDriveIterations() {
        checkNotNull();
        return _getInternalDriveIterations(address);
    }
    private static native int _getInternalDriveIterations(long address);

    /**
     * @param iterations WebIDL type: unsigned long
     */
    public void setExternalDriveIterations(int iterations) {
        checkNotNull();
        _setExternalDriveIterations(address, iterations);
    }
    private static native void _setExternalDriveIterations(long address, int iterations);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getExternalDriveIterations() {
        checkNotNull();
        return _getExternalDriveIterations(address);
    }
    private static native int _getExternalDriveIterations(long address);

    /**
     * @param compliance      WebIDL type: float
     * @param driveIterations WebIDL type: unsigned long
     * @return WebIDL type: {@link PxArticulationDriveCache}
     */
    public PxArticulationDriveCache createDriveCache(float compliance, int driveIterations) {
        checkNotNull();
        return PxArticulationDriveCache.wrapPointer(_createDriveCache(address, compliance, driveIterations));
    }
    private static native long _createDriveCache(long address, float compliance, int driveIterations);

    /**
     * @param driveCache      WebIDL type: {@link PxArticulationDriveCache} [Ref]
     * @param compliance      WebIDL type: float
     * @param driveIterations WebIDL type: unsigned long
     */
    public void updateDriveCache(PxArticulationDriveCache driveCache, float compliance, int driveIterations) {
        checkNotNull();
        _updateDriveCache(address, driveCache.getAddress(), compliance, driveIterations);
    }
    private static native void _updateDriveCache(long address, long driveCache, float compliance, int driveIterations);

    /**
     * @param driveCache WebIDL type: {@link PxArticulationDriveCache} [Ref]
     */
    public void releaseDriveCache(PxArticulationDriveCache driveCache) {
        checkNotNull();
        _releaseDriveCache(address, driveCache.getAddress());
    }
    private static native void _releaseDriveCache(long address, long driveCache);

    /**
     * @param link           WebIDL type: {@link PxArticulationLink}
     * @param driveCache     WebIDL type: {@link PxArticulationDriveCache} [Const, Ref]
     * @param linearImpulse  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param angularImpulse WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void applyImpulse(PxArticulationLink link, PxArticulationDriveCache driveCache, PxVec3 linearImpulse, PxVec3 angularImpulse) {
        checkNotNull();
        _applyImpulse(address, link.getAddress(), driveCache.getAddress(), linearImpulse.getAddress(), angularImpulse.getAddress());
    }
    private static native void _applyImpulse(long address, long link, long driveCache, long linearImpulse, long angularImpulse);

    /**
     * @param link            WebIDL type: {@link PxArticulationLink}
     * @param linearResponse  WebIDL type: {@link PxVec3} [Ref]
     * @param angularResponse WebIDL type: {@link PxVec3} [Ref]
     * @param driveCache      WebIDL type: {@link PxArticulationDriveCache} [Const, Ref]
     * @param linearImpulse   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param angularImpulse  WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void computeImpulseResponse(PxArticulationLink link, PxVec3 linearResponse, PxVec3 angularResponse, PxArticulationDriveCache driveCache, PxVec3 linearImpulse, PxVec3 angularImpulse) {
        checkNotNull();
        _computeImpulseResponse(address, link.getAddress(), linearResponse.getAddress(), angularResponse.getAddress(), driveCache.getAddress(), linearImpulse.getAddress(), angularImpulse.getAddress());
    }
    private static native void _computeImpulseResponse(long address, long link, long linearResponse, long angularResponse, long driveCache, long linearImpulse, long angularImpulse);

}
