package physx.physics;


public class JavaQueryFilterCallback extends SimpleQueryFilterCallback {

    public static JavaQueryFilterCallback wrapPointer(long address) {
        return address != 0L ? new JavaQueryFilterCallback(address) : null;
    }
    
    protected JavaQueryFilterCallback(long address) {
        super(address);
    }

    protected JavaQueryFilterCallback() {
        address = _JavaQueryFilterCallback();
    }
    private native long _JavaQueryFilterCallback();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private int _simplePreFilter(long filterData, long shape, long actor, long queryFlags) {
        return simplePreFilter(PxFilterData.wrapPointer(filterData), PxShape.wrapPointer(shape), PxRigidActor.wrapPointer(actor), PxHitFlags.wrapPointer(queryFlags));
    }

    /**
     * @param filterData WebIDL type: {@link PxFilterData} [Const, Ref]
     * @param shape      WebIDL type: {@link PxShape} [Const]
     * @param actor      WebIDL type: {@link PxRigidActor} [Const]
     * @param queryFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @return WebIDL type: unsigned long
     */
    public int simplePreFilter(PxFilterData filterData, PxShape shape, PxRigidActor actor, PxHitFlags queryFlags) {
        return 0;
    }

    /*
     * Called from native code
     */
    private int _simplePostFilter(long filterData, long hit) {
        return simplePostFilter(PxFilterData.wrapPointer(filterData), PxQueryHit.wrapPointer(hit));
    }

    /**
     * @param filterData WebIDL type: {@link PxFilterData} [Const, Ref]
     * @param hit        WebIDL type: {@link PxQueryHit} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int simplePostFilter(PxFilterData filterData, PxQueryHit hit) {
        return 0;
    }

}
