package physx.geomutils;

import physx.NativeObject;

public class PxGeometry extends NativeObject {

    protected PxGeometry() { }

    public static PxGeometry wrapPointer(long address) {
        return address != 0L ? new PxGeometry(address) : null;
    }
    
    protected PxGeometry(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: {@link PxGeometryTypeEnum} [enum]
     */
    public int getType() {
        checkNotNull();
        return _getType(address);
    }
    private static native int _getType(long address);

}
