package physx.extensions;

import physx.common.PxTransform;
import physx.common.PxVec3;

public class PxD6Joint extends PxJoint {

    protected PxD6Joint() { }

    public static PxD6Joint wrapPointer(long address) {
        return address != 0L ? new PxD6Joint(address) : null;
    }
    
    protected PxD6Joint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param axis WebIDL type: {@link PxD6AxisEnum} [enum]
     * @param type WebIDL type: {@link PxD6MotionEnum} [enum]
     */
    public void setMotion(int axis, int type) {
        checkNotNull();
        _setMotion(address, axis, type);
    }
    private static native void _setMotion(long address, int axis, int type);

    /**
     * @param axis WebIDL type: {@link PxD6AxisEnum} [enum]
     * @return WebIDL type: {@link PxD6MotionEnum} [enum]
     */
    public int getMotion(int axis) {
        checkNotNull();
        return _getMotion(address, axis);
    }
    private static native int _getMotion(long address, int axis);

    /**
     * @return WebIDL type: float
     */
    public float getTwistAngle() {
        checkNotNull();
        return _getTwistAngle(address);
    }
    private static native float _getTwistAngle(long address);

    /**
     * @return WebIDL type: float
     */
    public float getSwingYAngle() {
        checkNotNull();
        return _getSwingYAngle(address);
    }
    private static native float _getSwingYAngle(long address);

    /**
     * @return WebIDL type: float
     */
    public float getSwingZAngle() {
        checkNotNull();
        return _getSwingZAngle(address);
    }
    private static native float _getSwingZAngle(long address);

    /**
     * @param limit WebIDL type: {@link PxJointLinearLimit} [Const, Ref]
     */
    public void setDistanceLimit(PxJointLinearLimit limit) {
        checkNotNull();
        _setDistanceLimit(address, limit.getAddress());
    }
    private static native void _setDistanceLimit(long address, long limit);

    /**
     * @param axis  WebIDL type: {@link PxD6AxisEnum} [enum]
     * @param limit WebIDL type: {@link PxJointLinearLimitPair} [Const, Ref]
     */
    public void setLinearLimit(int axis, PxJointLinearLimitPair limit) {
        checkNotNull();
        _setLinearLimit(address, axis, limit.getAddress());
    }
    private static native void _setLinearLimit(long address, int axis, long limit);

    /**
     * @param limit WebIDL type: {@link PxJointAngularLimitPair} [Const, Ref]
     */
    public void setTwistLimit(PxJointAngularLimitPair limit) {
        checkNotNull();
        _setTwistLimit(address, limit.getAddress());
    }
    private static native void _setTwistLimit(long address, long limit);

    /**
     * @param limit WebIDL type: {@link PxJointLimitCone} [Const, Ref]
     */
    public void setSwingLimit(PxJointLimitCone limit) {
        checkNotNull();
        _setSwingLimit(address, limit.getAddress());
    }
    private static native void _setSwingLimit(long address, long limit);

    /**
     * @param limit WebIDL type: {@link PxJointLimitPyramid} [Const, Ref]
     */
    public void setPyramidSwingLimit(PxJointLimitPyramid limit) {
        checkNotNull();
        _setPyramidSwingLimit(address, limit.getAddress());
    }
    private static native void _setPyramidSwingLimit(long address, long limit);

    /**
     * @param index WebIDL type: {@link PxD6DriveEnum} [enum]
     * @param drive WebIDL type: {@link PxD6JointDrive} [Const, Ref]
     */
    public void setDrive(int index, PxD6JointDrive drive) {
        checkNotNull();
        _setDrive(address, index, drive.getAddress());
    }
    private static native void _setDrive(long address, int index, long drive);

    /**
     * @param index WebIDL type: {@link PxD6DriveEnum} [enum]
     * @return WebIDL type: {@link PxD6JointDrive} [Value]
     */
    public PxD6JointDrive getDrive(int index) {
        checkNotNull();
        return PxD6JointDrive.wrapPointer(_getDrive(address, index));
    }
    private static native long _getDrive(long address, int index);

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setDrivePosition(PxTransform pose) {
        checkNotNull();
        _setDrivePosition(address, pose.getAddress());
    }
    private static native void _setDrivePosition(long address, long pose);

    /**
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param autowake WebIDL type: boolean
     */
    public void setDrivePosition(PxTransform pose, boolean autowake) {
        checkNotNull();
        _setDrivePosition(address, pose.getAddress(), autowake);
    }
    private static native void _setDrivePosition(long address, long pose, boolean autowake);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getDrivePosition() {
        checkNotNull();
        return PxTransform.wrapPointer(_getDrivePosition(address));
    }
    private static native long _getDrivePosition(long address);

    /**
     * @param linear  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param angular WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setDriveVelocity(PxVec3 linear, PxVec3 angular) {
        checkNotNull();
        _setDriveVelocity(address, linear.getAddress(), angular.getAddress());
    }
    private static native void _setDriveVelocity(long address, long linear, long angular);

    /**
     * @param linear  WebIDL type: {@link PxVec3} [Ref]
     * @param angular WebIDL type: {@link PxVec3} [Ref]
     */
    public void getDriveVelocity(PxVec3 linear, PxVec3 angular) {
        checkNotNull();
        _getDriveVelocity(address, linear.getAddress(), angular.getAddress());
    }
    private static native void _getDriveVelocity(long address, long linear, long angular);

    /**
     * @param tolerance WebIDL type: float
     */
    public void setProjectionLinearTolerance(float tolerance) {
        checkNotNull();
        _setProjectionLinearTolerance(address, tolerance);
    }
    private static native void _setProjectionLinearTolerance(long address, float tolerance);

    /**
     * @return WebIDL type: float
     */
    public float getProjectionLinearTolerance() {
        checkNotNull();
        return _getProjectionLinearTolerance(address);
    }
    private static native float _getProjectionLinearTolerance(long address);

    /**
     * @param tolerance WebIDL type: float
     */
    public void setProjectionAngularTolerance(float tolerance) {
        checkNotNull();
        _setProjectionAngularTolerance(address, tolerance);
    }
    private static native void _setProjectionAngularTolerance(long address, float tolerance);

    /**
     * @return WebIDL type: float
     */
    public float getProjectionAngularTolerance() {
        checkNotNull();
        return _getProjectionAngularTolerance(address);
    }
    private static native float _getProjectionAngularTolerance(long address);

}
