package physx.common;

import physx.NativeObject;

public class PxErrorCallback extends NativeObject {

    protected PxErrorCallback() { }

    public static PxErrorCallback wrapPointer(long address) {
        return address != 0L ? new PxErrorCallback(address) : null;
    }
    
    protected PxErrorCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param code    WebIDL type: {@link PxErrorCodeEnum} [enum]
     * @param message WebIDL type: DOMString [Const]
     * @param file    WebIDL type: DOMString [Const]
     * @param line    WebIDL type: long
     */
    public void reportError(int code, String message, String file, int line) {
        checkNotNull();
        _reportError(address, code, message, file, line);
    }
    private static native void _reportError(long address, int code, String message, String file, int line);

}
