package physx.character;


public class PxCapsuleControllerDesc extends PxControllerDesc {

    public static PxCapsuleControllerDesc wrapPointer(long address) {
        return address != 0L ? new PxCapsuleControllerDesc(address) : null;
    }
    
    protected PxCapsuleControllerDesc(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxCapsuleControllerDesc
     */
    public static PxCapsuleControllerDesc createAt(long address) {
        __placement_new_PxCapsuleControllerDesc(address);
        PxCapsuleControllerDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxCapsuleControllerDesc
     */
    public static <T> PxCapsuleControllerDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxCapsuleControllerDesc(address);
        PxCapsuleControllerDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxCapsuleControllerDesc(long address);

    // Constructors

    public PxCapsuleControllerDesc() {
        address = _PxCapsuleControllerDesc();
    }
    private static native long _PxCapsuleControllerDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getRadius() {
        checkNotNull();
        return _getRadius(address);
    }
    private static native float _getRadius(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRadius(float value) {
        checkNotNull();
        _setRadius(address, value);
    }
    private static native void _setRadius(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getHeight() {
        checkNotNull();
        return _getHeight(address);
    }
    private static native float _getHeight(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setHeight(float value) {
        checkNotNull();
        _setHeight(address, value);
    }
    private static native void _setHeight(long address, float value);

    /**
     * @return WebIDL type: {@link PxCapsuleClimbingModeEnum} [enum]
     */
    public int getClimbingMode() {
        checkNotNull();
        return _getClimbingMode(address);
    }
    private static native int _getClimbingMode(long address);

    /**
     * @param value WebIDL type: {@link PxCapsuleClimbingModeEnum} [enum]
     */
    public void setClimbingMode(int value) {
        checkNotNull();
        _setClimbingMode(address, value);
    }
    private static native void _setClimbingMode(long address, int value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
