package physx.character;


public class JavaUserControllerHitReport extends PxUserControllerHitReport {

    public static JavaUserControllerHitReport wrapPointer(long address) {
        return address != 0L ? new JavaUserControllerHitReport(address) : null;
    }
    
    protected JavaUserControllerHitReport(long address) {
        super(address);
    }

    protected JavaUserControllerHitReport() {
        address = _JavaUserControllerHitReport();
    }
    private native long _JavaUserControllerHitReport();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private void _onShapeHit(long hit) {
        onShapeHit(PxControllerShapeHit.wrapPointer(hit));
    }

    /**
     * @param hit WebIDL type: {@link PxControllerShapeHit} [Const, Ref]
     */
    public void onShapeHit(PxControllerShapeHit hit) { }

    /*
     * Called from native code
     */
    private void _onControllerHit(long hit) {
        onControllerHit(PxControllersHit.wrapPointer(hit));
    }

    /**
     * @param hit WebIDL type: {@link PxControllersHit} [Const, Ref]
     */
    public void onControllerHit(PxControllersHit hit) { }

    /*
     * Called from native code
     */
    private void _onObstacleHit(long hit) {
        onObstacleHit(PxControllerObstacleHit.wrapPointer(hit));
    }

    /**
     * @param hit WebIDL type: {@link PxControllerObstacleHit} [Const, Ref]
     */
    public void onObstacleHit(PxControllerObstacleHit hit) { }

}
