package physx.vehicle;

import physx.physics.PxPhysics;
import physx.physics.PxRigidDynamic;

public class PxVehicleDriveTank extends PxVehicleDrive {

    protected PxVehicleDriveTank() { }

    public static PxVehicleDriveTank wrapPointer(long address) {
        return address != 0L ? new PxVehicleDriveTank(address) : null;
    }
    
    protected PxVehicleDriveTank(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleDriveSimData} [Value]
     */
    public PxVehicleDriveSimData getMDriveSimData() {
        checkNotNull();
        return PxVehicleDriveSimData.wrapPointer(_getMDriveSimData(address));
    }
    private static native long _getMDriveSimData(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleDriveSimData} [Value]
     */
    public void setMDriveSimData(PxVehicleDriveSimData value) {
        checkNotNull();
        _setMDriveSimData(address, value.getAddress());
    }
    private static native void _setMDriveSimData(long address, long value);

    // Functions

    /**
     * @param nbWheels WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVehicleDriveTank}
     */
    public static PxVehicleDriveTank allocate(int nbWheels) {
        return PxVehicleDriveTank.wrapPointer(_allocate(nbWheels));
    }
    private static native long _allocate(int nbWheels);

    public void free() {
        checkNotNull();
        _free(address);
    }
    private static native void _free(long address);

    /**
     * @param physics        WebIDL type: {@link PxPhysics}
     * @param vehActor       WebIDL type: {@link PxRigidDynamic}
     * @param wheelsData     WebIDL type: {@link PxVehicleWheelsSimData} [Const, Ref]
     * @param driveData      WebIDL type: {@link PxVehicleDriveSimData} [Const, Ref]
     * @param nbDrivenWheels WebIDL type: unsigned long
     */
    public void setup(PxPhysics physics, PxRigidDynamic vehActor, PxVehicleWheelsSimData wheelsData, PxVehicleDriveSimData driveData, int nbDrivenWheels) {
        checkNotNull();
        _setup(address, physics.getAddress(), vehActor.getAddress(), wheelsData.getAddress(), driveData.getAddress(), nbDrivenWheels);
    }
    private static native void _setup(long address, long physics, long vehActor, long wheelsData, long driveData, int nbDrivenWheels);

    /**
     * @param driveModel WebIDL type: {@link PxVehicleDriveTankControlModelEnum} [enum]
     */
    public void setDriveModel(int driveModel) {
        checkNotNull();
        _setDriveModel(address, driveModel);
    }
    private static native void _setDriveModel(long address, int driveModel);

    /**
     * @return WebIDL type: {@link PxVehicleDriveTankControlModelEnum} [enum]
     */
    public int getDriveModel() {
        checkNotNull();
        return _getDriveModel(address);
    }
    private static native int _getDriveModel(long address);

    public void setToRestState() {
        checkNotNull();
        _setToRestState(address);
    }
    private static native void _setToRestState(long address);

}
