package physx.support;


public class JavaPassThroughFilterShader extends PassThroughFilterShader {

    public static JavaPassThroughFilterShader wrapPointer(long address) {
        return address != 0L ? new JavaPassThroughFilterShader(address) : null;
    }
    
    protected JavaPassThroughFilterShader(long address) {
        super(address);
    }

    protected JavaPassThroughFilterShader() {
        address = _JavaPassThroughFilterShader();
    }
    private native long _JavaPassThroughFilterShader();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private int _filterShader(int attributes0, int filterData0w0, int filterData0w1, int filterData0w2, int filterData0w3, int attributes1, int filterData1w0, int filterData1w1, int filterData1w2, int filterData1w3) {
        return filterShader(attributes0, filterData0w0, filterData0w1, filterData0w2, filterData0w3, attributes1, filterData1w0, filterData1w1, filterData1w2, filterData1w3);
    }

    /**
     * @param attributes0   WebIDL type: unsigned long
     * @param filterData0w0 WebIDL type: unsigned long
     * @param filterData0w1 WebIDL type: unsigned long
     * @param filterData0w2 WebIDL type: unsigned long
     * @param filterData0w3 WebIDL type: unsigned long
     * @param attributes1   WebIDL type: unsigned long
     * @param filterData1w0 WebIDL type: unsigned long
     * @param filterData1w1 WebIDL type: unsigned long
     * @param filterData1w2 WebIDL type: unsigned long
     * @param filterData1w3 WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int filterShader(int attributes0, int filterData0w0, int filterData0w1, int filterData0w2, int filterData0w3, int attributes1, int filterData1w0, int filterData1w1, int filterData1w2, int filterData1w3) {
        return 0;
    }

}
