package physx.physics;

import physx.NativeObject;

public class PxContactPair extends NativeObject {

    protected PxContactPair() { }

    public static PxContactPair wrapPointer(long address) {
        return address != 0L ? new PxContactPair(address) : null;
    }
    
    protected PxContactPair(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape getShapes(int index) {
        checkNotNull();
        return PxShape.wrapPointer(_getShapes(address, index));
    }
    private static native long _getShapes(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxShape}
     */
    public void setShapes(int index, PxShape value) {
        checkNotNull();
        _setShapes(address, index, value.getAddress());
    }
    private static native void _setShapes(long address, int index, long value);

    /**
     * @return WebIDL type: octet
     */
    public byte getContactCount() {
        checkNotNull();
        return _getContactCount(address);
    }
    private static native byte _getContactCount(long address);

    /**
     * @param value WebIDL type: octet
     */
    public void setContactCount(byte value) {
        checkNotNull();
        _setContactCount(address, value);
    }
    private static native void _setContactCount(long address, byte value);

    /**
     * @return WebIDL type: octet
     */
    public byte getPatchCount() {
        checkNotNull();
        return _getPatchCount(address);
    }
    private static native byte _getPatchCount(long address);

    /**
     * @param value WebIDL type: octet
     */
    public void setPatchCount(byte value) {
        checkNotNull();
        _setPatchCount(address, value);
    }
    private static native void _setPatchCount(long address, byte value);

    /**
     * @return WebIDL type: {@link PxContactPairFlags} [Value]
     */
    public PxContactPairFlags getFlags() {
        checkNotNull();
        return PxContactPairFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxContactPairFlags} [Value]
     */
    public void setFlags(PxContactPairFlags value) {
        checkNotNull();
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

    /**
     * @return WebIDL type: {@link PxPairFlags} [Value]
     */
    public PxPairFlags getEvents() {
        checkNotNull();
        return PxPairFlags.wrapPointer(_getEvents(address));
    }
    private static native long _getEvents(long address);

    /**
     * @param value WebIDL type: {@link PxPairFlags} [Value]
     */
    public void setEvents(PxPairFlags value) {
        checkNotNull();
        _setEvents(address, value.getAddress());
    }
    private static native void _setEvents(long address, long value);

    // Functions

    /**
     * @param userBuffer WebIDL type: {@link PxContactPairPoint}
     * @param bufferSize WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int extractContacts(PxContactPairPoint userBuffer, int bufferSize) {
        checkNotNull();
        return _extractContacts(address, userBuffer.getAddress(), bufferSize);
    }
    private static native int _extractContacts(long address, long userBuffer, int bufferSize);

}
