package physx.physics;

import physx.support.PxActorPtr;

public class JavaSimulationEventCallback extends SimpleSimulationEventCallback {

    public static JavaSimulationEventCallback wrapPointer(long address) {
        return address != 0L ? new JavaSimulationEventCallback(address) : null;
    }
    
    protected JavaSimulationEventCallback(long address) {
        super(address);
    }

    protected JavaSimulationEventCallback() {
        address = _JavaSimulationEventCallback();
    }
    private native long _JavaSimulationEventCallback();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private void _onConstraintBreak(long constraints, int count) {
        onConstraintBreak(PxConstraintInfo.wrapPointer(constraints), count);
    }

    /**
     * @param constraints WebIDL type: {@link PxConstraintInfo}
     * @param count       WebIDL type: unsigned long
     */
    public void onConstraintBreak(PxConstraintInfo constraints, int count) { }

    /*
     * Called from native code
     */
    private void _onWake(long actors, int count) {
        onWake(PxActorPtr.wrapPointer(actors), count);
    }

    /**
     * @param actors WebIDL type: {@link PxActorPtr}
     * @param count  WebIDL type: unsigned long
     */
    public void onWake(PxActorPtr actors, int count) { }

    /*
     * Called from native code
     */
    private void _onSleep(long actors, int count) {
        onSleep(PxActorPtr.wrapPointer(actors), count);
    }

    /**
     * @param actors WebIDL type: {@link PxActorPtr}
     * @param count  WebIDL type: unsigned long
     */
    public void onSleep(PxActorPtr actors, int count) { }

    /*
     * Called from native code
     */
    private void _onContact(long pairHeader, long pairs, int nbPairs) {
        onContact(PxContactPairHeader.wrapPointer(pairHeader), PxContactPair.wrapPointer(pairs), nbPairs);
    }

    /**
     * @param pairHeader WebIDL type: {@link PxContactPairHeader} [Const, Ref]
     * @param pairs      WebIDL type: {@link PxContactPair} [Const]
     * @param nbPairs    WebIDL type: unsigned long
     */
    public void onContact(PxContactPairHeader pairHeader, PxContactPair pairs, int nbPairs) { }

    /*
     * Called from native code
     */
    private void _onTrigger(long pairs, int count) {
        onTrigger(PxTriggerPair.wrapPointer(pairs), count);
    }

    /**
     * @param pairs WebIDL type: {@link PxTriggerPair}
     * @param count WebIDL type: unsigned long
     */
    public void onTrigger(PxTriggerPair pairs, int count) { }

}
