package physx.character;


public class PxBoxController extends PxController {

    protected PxBoxController() { }

    public static PxBoxController wrapPointer(long address) {
        return address != 0L ? new PxBoxController(address) : null;
    }
    
    protected PxBoxController(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: float
     */
    public float getHalfHeight() {
        checkNotNull();
        return _getHalfHeight(address);
    }
    private static native float _getHalfHeight(long address);

    /**
     * @return WebIDL type: float
     */
    public float getHalfSideExtent() {
        checkNotNull();
        return _getHalfSideExtent(address);
    }
    private static native float _getHalfSideExtent(long address);

    /**
     * @return WebIDL type: float
     */
    public float getHalfForwardExtent() {
        checkNotNull();
        return _getHalfForwardExtent(address);
    }
    private static native float _getHalfForwardExtent(long address);

    /**
     * @param halfHeight WebIDL type: float
     */
    public void setHalfHeight(float halfHeight) {
        checkNotNull();
        _setHalfHeight(address, halfHeight);
    }
    private static native void _setHalfHeight(long address, float halfHeight);

    /**
     * @param halfSideExtent WebIDL type: float
     */
    public void setHalfSideExtent(float halfSideExtent) {
        checkNotNull();
        _setHalfSideExtent(address, halfSideExtent);
    }
    private static native void _setHalfSideExtent(long address, float halfSideExtent);

    /**
     * @param halfForwardExtent WebIDL type: float
     */
    public void setHalfForwardExtent(float halfForwardExtent) {
        checkNotNull();
        _setHalfForwardExtent(address, halfForwardExtent);
    }
    private static native void _setHalfForwardExtent(long address, float halfForwardExtent);

}
