package physx.support;

import physx.NativeObject;

public class PxU16Ptr extends NativeObject {

    protected PxU16Ptr() { }

    public static PxU16Ptr wrapPointer(long address) {
        return address != 0L ? new PxU16Ptr(address) : null;
    }
    
    protected PxU16Ptr(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
