package physx.physics;

import physx.NativeObject;

public class PxRaycastCallback extends NativeObject {

    protected PxRaycastCallback() { }

    public static PxRaycastCallback wrapPointer(long address) {
        return address != 0L ? new PxRaycastCallback(address) : null;
    }
    
    protected PxRaycastCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean hasAnyHits() {
        checkNotNull();
        return _hasAnyHits(address);
    }
    private static native boolean _hasAnyHits(long address);

}
