package physx.geomutils;


public class PxCapsuleGeometry extends PxGeometry {

    protected PxCapsuleGeometry() { }

    public static PxCapsuleGeometry wrapPointer(long address) {
        return address != 0L ? new PxCapsuleGeometry(address) : null;
    }
    
    protected PxCapsuleGeometry(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address    Pre-allocated memory, where the object is created.
     * @param radius     WebIDL type: float
     * @param halfHeight WebIDL type: float
     * @return Stack allocated object of PxCapsuleGeometry
     */
    public static PxCapsuleGeometry createAt(long address, float radius, float halfHeight) {
        __placement_new_PxCapsuleGeometry(address, radius, halfHeight);
        PxCapsuleGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>        Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator  Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate   Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param radius     WebIDL type: float
     * @param halfHeight WebIDL type: float
     * @return Stack allocated object of PxCapsuleGeometry
     */
    public static <T> PxCapsuleGeometry createAt(T allocator, Allocator<T> allocate, float radius, float halfHeight) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxCapsuleGeometry(address, radius, halfHeight);
        PxCapsuleGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxCapsuleGeometry(long address, float radius, float halfHeight);

    // Constructors

    /**
     * @param radius     WebIDL type: float
     * @param halfHeight WebIDL type: float
     */
    public PxCapsuleGeometry(float radius, float halfHeight) {
        address = _PxCapsuleGeometry(radius, halfHeight);
    }
    private static native long _PxCapsuleGeometry(float radius, float halfHeight);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
