package physx.vehicle;


public class PxVehicleDriveSimData4W extends PxVehicleDriveSimData {

    public static PxVehicleDriveSimData4W wrapPointer(long address) {
        return address != 0L ? new PxVehicleDriveSimData4W(address) : null;
    }
    
    protected PxVehicleDriveSimData4W(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleDriveSimData4W
     */
    public static PxVehicleDriveSimData4W createAt(long address) {
        __placement_new_PxVehicleDriveSimData4W(address);
        PxVehicleDriveSimData4W createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleDriveSimData4W
     */
    public static <T> PxVehicleDriveSimData4W createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleDriveSimData4W(address);
        PxVehicleDriveSimData4W createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleDriveSimData4W(long address);

    // Constructors

    public PxVehicleDriveSimData4W() {
        address = _PxVehicleDriveSimData4W();
    }
    private static native long _PxVehicleDriveSimData4W();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: {@link PxVehicleDifferential4WData} [Const, Ref]
     */
    public PxVehicleDifferential4WData getDiffData() {
        checkNotNull();
        return PxVehicleDifferential4WData.wrapPointer(_getDiffData(address));
    }
    private static native long _getDiffData(long address);

    /**
     * @return WebIDL type: {@link PxVehicleAckermannGeometryData} [Const, Ref]
     */
    public PxVehicleAckermannGeometryData getAckermannGeometryData() {
        checkNotNull();
        return PxVehicleAckermannGeometryData.wrapPointer(_getAckermannGeometryData(address));
    }
    private static native long _getAckermannGeometryData(long address);

    /**
     * @param diff WebIDL type: {@link PxVehicleDifferential4WData} [Const, Ref]
     */
    public void setDiffData(PxVehicleDifferential4WData diff) {
        checkNotNull();
        _setDiffData(address, diff.getAddress());
    }
    private static native void _setDiffData(long address, long diff);

    /**
     * @param ackermannData WebIDL type: {@link PxVehicleAckermannGeometryData} [Const, Ref]
     */
    public void setAckermannGeometryData(PxVehicleAckermannGeometryData ackermannData) {
        checkNotNull();
        _setAckermannGeometryData(address, ackermannData.getAddress());
    }
    private static native void _setAckermannGeometryData(long address, long ackermannData);

}
