package physx.physics;

import physx.NativeObject;

public class PxQueryFilterData extends NativeObject {

    public static PxQueryFilterData wrapPointer(long address) {
        return address != 0L ? new PxQueryFilterData(address) : null;
    }
    
    protected PxQueryFilterData(long address) {
        super(address);
    }

    // Constructors

    public PxQueryFilterData() {
        address = _PxQueryFilterData();
    }
    private static native long _PxQueryFilterData();

    /**
     * @param fd WebIDL type: {@link PxFilterData} [Const, Ref]
     * @param f  WebIDL type: {@link PxQueryFlags} [Ref]
     */
    public PxQueryFilterData(PxFilterData fd, PxQueryFlags f) {
        address = _PxQueryFilterData(fd.getAddress(), f.getAddress());
    }
    private static native long _PxQueryFilterData(long fd, long f);

    /**
     * @param f WebIDL type: {@link PxQueryFlags} [Ref]
     */
    public PxQueryFilterData(PxQueryFlags f) {
        address = _PxQueryFilterData(f.getAddress());
    }
    private static native long _PxQueryFilterData(long f);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxFilterData} [Value]
     */
    public PxFilterData getData() {
        checkNotNull();
        return PxFilterData.wrapPointer(_getData(address));
    }
    private static native long _getData(long address);

    /**
     * @param value WebIDL type: {@link PxFilterData} [Value]
     */
    public void setData(PxFilterData value) {
        checkNotNull();
        _setData(address, value.getAddress());
    }
    private static native void _setData(long address, long value);

    /**
     * @return WebIDL type: {@link PxQueryFlags} [Value]
     */
    public PxQueryFlags getFlags() {
        checkNotNull();
        return PxQueryFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxQueryFlags} [Value]
     */
    public void setFlags(PxQueryFlags value) {
        checkNotNull();
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

}
