package physx.geomutils;


public class PxHeightFieldGeometry extends PxGeometry {

    public static PxHeightFieldGeometry wrapPointer(long address) {
        return address != 0L ? new PxHeightFieldGeometry(address) : null;
    }
    
    protected PxHeightFieldGeometry(long address) {
        super(address);
    }

    // Constructors

    public PxHeightFieldGeometry() {
        address = _PxHeightFieldGeometry();
    }
    private static native long _PxHeightFieldGeometry();

    /**
     * @param hf          WebIDL type: {@link PxHeightField}
     * @param flags       WebIDL type: {@link PxMeshGeometryFlags} [Ref]
     * @param heightScale WebIDL type: float
     * @param rowScale    WebIDL type: float
     * @param columnScale WebIDL type: float
     */
    public PxHeightFieldGeometry(PxHeightField hf, PxMeshGeometryFlags flags, float heightScale, float rowScale, float columnScale) {
        address = _PxHeightFieldGeometry(hf.getAddress(), flags.getAddress(), heightScale, rowScale, columnScale);
    }
    private static native long _PxHeightFieldGeometry(long hf, long flags, float heightScale, float rowScale, float columnScale);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxHeightField}
     */
    public PxHeightField getHeightField() {
        checkNotNull();
        return PxHeightField.wrapPointer(_getHeightField(address));
    }
    private static native long _getHeightField(long address);

    /**
     * @param value WebIDL type: {@link PxHeightField}
     */
    public void setHeightField(PxHeightField value) {
        checkNotNull();
        _setHeightField(address, value.getAddress());
    }
    private static native void _setHeightField(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getHeightScale() {
        checkNotNull();
        return _getHeightScale(address);
    }
    private static native float _getHeightScale(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setHeightScale(float value) {
        checkNotNull();
        _setHeightScale(address, value);
    }
    private static native void _setHeightScale(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getRowScale() {
        checkNotNull();
        return _getRowScale(address);
    }
    private static native float _getRowScale(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRowScale(float value) {
        checkNotNull();
        _setRowScale(address, value);
    }
    private static native void _setRowScale(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getColumnScale() {
        checkNotNull();
        return _getColumnScale(address);
    }
    private static native float _getColumnScale(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setColumnScale(float value) {
        checkNotNull();
        _setColumnScale(address, value);
    }
    private static native void _setColumnScale(long address, float value);

    /**
     * @return WebIDL type: {@link PxMeshGeometryFlags} [Value]
     */
    public PxMeshGeometryFlags getHeightFieldFlags() {
        checkNotNull();
        return PxMeshGeometryFlags.wrapPointer(_getHeightFieldFlags(address));
    }
    private static native long _getHeightFieldFlags(long address);

    /**
     * @param value WebIDL type: {@link PxMeshGeometryFlags} [Value]
     */
    public void setHeightFieldFlags(PxMeshGeometryFlags value) {
        checkNotNull();
        _setHeightFieldFlags(address, value.getAddress());
    }
    private static native void _setHeightFieldFlags(long address, long value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
