package physx.extensions;


public class PxFixedJoint extends PxJoint {

    protected PxFixedJoint() { }

    public static PxFixedJoint wrapPointer(long address) {
        return address != 0L ? new PxFixedJoint(address) : null;
    }
    
    protected PxFixedJoint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param tolerance WebIDL type: float
     */
    public void setProjectionLinearTolerance(float tolerance) {
        checkNotNull();
        _setProjectionLinearTolerance(address, tolerance);
    }
    private static native void _setProjectionLinearTolerance(long address, float tolerance);

    /**
     * @return WebIDL type: float
     */
    public float getProjectionLinearTolerance() {
        checkNotNull();
        return _getProjectionLinearTolerance(address);
    }
    private static native float _getProjectionLinearTolerance(long address);

    /**
     * @param tolerance WebIDL type: float
     */
    public void setProjectionAngularTolerance(float tolerance) {
        checkNotNull();
        _setProjectionAngularTolerance(address, tolerance);
    }
    private static native void _setProjectionAngularTolerance(long address, float tolerance);

    /**
     * @return WebIDL type: float
     */
    public float getProjectionAngularTolerance() {
        checkNotNull();
        return _getProjectionAngularTolerance(address);
    }
    private static native float _getProjectionAngularTolerance(long address);

}
