package physx.character;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.physics.PxScene;

public class PxControllerManager extends NativeObject {

    protected PxControllerManager() { }

    public static PxControllerManager wrapPointer(long address) {
        return address != 0L ? new PxControllerManager(address) : null;
    }
    
    protected PxControllerManager(long address) {
        super(address);
    }

    // Functions

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @return WebIDL type: {@link PxScene} [Ref]
     */
    public PxScene getScene() {
        checkNotNull();
        return PxScene.wrapPointer(_getScene(address));
    }
    private static native long _getScene(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbControllers() {
        checkNotNull();
        return _getNbControllers(address);
    }
    private static native int _getNbControllers(long address);

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxController}
     */
    public PxController getController(int index) {
        checkNotNull();
        return PxController.wrapPointer(_getController(address, index));
    }
    private static native long _getController(long address, int index);

    /**
     * @param desc WebIDL type: {@link PxControllerDesc} [Const, Ref]
     * @return WebIDL type: {@link PxController}
     */
    public PxController createController(PxControllerDesc desc) {
        checkNotNull();
        return PxController.wrapPointer(_createController(address, desc.getAddress()));
    }
    private static native long _createController(long address, long desc);

    public void purgeControllers() {
        checkNotNull();
        _purgeControllers(address);
    }
    private static native void _purgeControllers(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbObstacleContexts() {
        checkNotNull();
        return _getNbObstacleContexts(address);
    }
    private static native int _getNbObstacleContexts(long address);

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxObstacleContext}
     */
    public PxObstacleContext getObstacleContext(int index) {
        checkNotNull();
        return PxObstacleContext.wrapPointer(_getObstacleContext(address, index));
    }
    private static native long _getObstacleContext(long address, int index);

    /**
     * @return WebIDL type: {@link PxObstacleContext}
     */
    public PxObstacleContext createObstacleContext() {
        checkNotNull();
        return PxObstacleContext.wrapPointer(_createObstacleContext(address));
    }
    private static native long _createObstacleContext(long address);

    /**
     * @param elapsedTime WebIDL type: float
     */
    public void computeInteractions(float elapsedTime) {
        checkNotNull();
        _computeInteractions(address, elapsedTime);
    }
    private static native void _computeInteractions(long address, float elapsedTime);

    /**
     * @param flag          WebIDL type: boolean
     * @param maxEdgeLength WebIDL type: float
     */
    public void setTessellation(boolean flag, float maxEdgeLength) {
        checkNotNull();
        _setTessellation(address, flag, maxEdgeLength);
    }
    private static native void _setTessellation(long address, boolean flag, float maxEdgeLength);

    /**
     * @param flag WebIDL type: boolean
     */
    public void setOverlapRecoveryModule(boolean flag) {
        checkNotNull();
        _setOverlapRecoveryModule(address, flag);
    }
    private static native void _setOverlapRecoveryModule(long address, boolean flag);

    /**
     * @param flags WebIDL type: boolean
     */
    public void setPreciseSweeps(boolean flags) {
        checkNotNull();
        _setPreciseSweeps(address, flags);
    }
    private static native void _setPreciseSweeps(long address, boolean flags);

    /**
     * @param flag WebIDL type: boolean
     */
    public void setPreventVerticalSlidingAgainstCeiling(boolean flag) {
        checkNotNull();
        _setPreventVerticalSlidingAgainstCeiling(address, flag);
    }
    private static native void _setPreventVerticalSlidingAgainstCeiling(long address, boolean flag);

    /**
     * @param shift WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void shiftOrigin(PxVec3 shift) {
        checkNotNull();
        _shiftOrigin(address, shift.getAddress());
    }
    private static native void _shiftOrigin(long address, long shift);

}
