package physx.vehicle;

import physx.NativeObject;

public class PxVehicleEngineData extends NativeObject {

    public static PxVehicleEngineData wrapPointer(long address) {
        return address != 0L ? new PxVehicleEngineData(address) : null;
    }
    
    protected PxVehicleEngineData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleEngineData() {
        address = _PxVehicleEngineData();
    }
    private static native long _PxVehicleEngineData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxEngineTorqueLookupTable} [Value]
     */
    public PxEngineTorqueLookupTable getMTorqueCurve() {
        checkNotNull();
        return PxEngineTorqueLookupTable.wrapPointer(_getMTorqueCurve(address));
    }
    private static native long _getMTorqueCurve(long address);

    /**
     * @param value WebIDL type: {@link PxEngineTorqueLookupTable} [Value]
     */
    public void setMTorqueCurve(PxEngineTorqueLookupTable value) {
        checkNotNull();
        _setMTorqueCurve(address, value.getAddress());
    }
    private static native void _setMTorqueCurve(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getMMOI() {
        checkNotNull();
        return _getMMOI(address);
    }
    private static native float _getMMOI(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMOI(float value) {
        checkNotNull();
        _setMMOI(address, value);
    }
    private static native void _setMMOI(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMPeakTorque() {
        checkNotNull();
        return _getMPeakTorque(address);
    }
    private static native float _getMPeakTorque(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMPeakTorque(float value) {
        checkNotNull();
        _setMPeakTorque(address, value);
    }
    private static native void _setMPeakTorque(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxOmega() {
        checkNotNull();
        return _getMMaxOmega(address);
    }
    private static native float _getMMaxOmega(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxOmega(float value) {
        checkNotNull();
        _setMMaxOmega(address, value);
    }
    private static native void _setMMaxOmega(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMDampingRateFullThrottle() {
        checkNotNull();
        return _getMDampingRateFullThrottle(address);
    }
    private static native float _getMDampingRateFullThrottle(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMDampingRateFullThrottle(float value) {
        checkNotNull();
        _setMDampingRateFullThrottle(address, value);
    }
    private static native void _setMDampingRateFullThrottle(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMDampingRateZeroThrottleClutchEngaged() {
        checkNotNull();
        return _getMDampingRateZeroThrottleClutchEngaged(address);
    }
    private static native float _getMDampingRateZeroThrottleClutchEngaged(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMDampingRateZeroThrottleClutchEngaged(float value) {
        checkNotNull();
        _setMDampingRateZeroThrottleClutchEngaged(address, value);
    }
    private static native void _setMDampingRateZeroThrottleClutchEngaged(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMDampingRateZeroThrottleClutchDisengaged() {
        checkNotNull();
        return _getMDampingRateZeroThrottleClutchDisengaged(address);
    }
    private static native float _getMDampingRateZeroThrottleClutchDisengaged(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMDampingRateZeroThrottleClutchDisengaged(float value) {
        checkNotNull();
        _setMDampingRateZeroThrottleClutchDisengaged(address, value);
    }
    private static native void _setMDampingRateZeroThrottleClutchDisengaged(long address, float value);

}
