package physx.vehicle;

import physx.NativeObject;

public class PxVehicleDifferential4WData extends NativeObject {

    public static PxVehicleDifferential4WData wrapPointer(long address) {
        return address != 0L ? new PxVehicleDifferential4WData(address) : null;
    }
    
    protected PxVehicleDifferential4WData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleDifferential4WData() {
        address = _PxVehicleDifferential4WData();
    }
    private static native long _PxVehicleDifferential4WData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMFrontRearSplit() {
        checkNotNull();
        return _getMFrontRearSplit(address);
    }
    private static native float _getMFrontRearSplit(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMFrontRearSplit(float value) {
        checkNotNull();
        _setMFrontRearSplit(address, value);
    }
    private static native void _setMFrontRearSplit(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMFrontLeftRightSplit() {
        checkNotNull();
        return _getMFrontLeftRightSplit(address);
    }
    private static native float _getMFrontLeftRightSplit(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMFrontLeftRightSplit(float value) {
        checkNotNull();
        _setMFrontLeftRightSplit(address, value);
    }
    private static native void _setMFrontLeftRightSplit(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMRearLeftRightSplit() {
        checkNotNull();
        return _getMRearLeftRightSplit(address);
    }
    private static native float _getMRearLeftRightSplit(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMRearLeftRightSplit(float value) {
        checkNotNull();
        _setMRearLeftRightSplit(address, value);
    }
    private static native void _setMRearLeftRightSplit(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMCentreBias() {
        checkNotNull();
        return _getMCentreBias(address);
    }
    private static native float _getMCentreBias(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMCentreBias(float value) {
        checkNotNull();
        _setMCentreBias(address, value);
    }
    private static native void _setMCentreBias(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMFrontBias() {
        checkNotNull();
        return _getMFrontBias(address);
    }
    private static native float _getMFrontBias(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMFrontBias(float value) {
        checkNotNull();
        _setMFrontBias(address, value);
    }
    private static native void _setMFrontBias(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMRearBias() {
        checkNotNull();
        return _getMRearBias(address);
    }
    private static native float _getMRearBias(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMRearBias(float value) {
        checkNotNull();
        _setMRearBias(address, value);
    }
    private static native void _setMRearBias(long address, float value);

    /**
     * @return WebIDL type: {@link PxVehicleDifferential4WDataEnum} [enum]
     */
    public int getMType() {
        checkNotNull();
        return _getMType(address);
    }
    private static native int _getMType(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleDifferential4WDataEnum} [enum]
     */
    public void setMType(int value) {
        checkNotNull();
        _setMType(address, value);
    }
    private static native void _setMType(long address, int value);

}
