package physx.physics;

import physx.NativeObject;

public class PxgDynamicsMemoryConfig extends NativeObject {

    public static PxgDynamicsMemoryConfig wrapPointer(long address) {
        return address != 0L ? new PxgDynamicsMemoryConfig(address) : null;
    }
    
    protected PxgDynamicsMemoryConfig(long address) {
        super(address);
    }

    // Constructors

    public PxgDynamicsMemoryConfig() {
        address = _PxgDynamicsMemoryConfig();
    }
    private static native long _PxgDynamicsMemoryConfig();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getConstraintBufferCapacity() {
        checkNotNull();
        return _getConstraintBufferCapacity(address);
    }
    private static native int _getConstraintBufferCapacity(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setConstraintBufferCapacity(int value) {
        checkNotNull();
        _setConstraintBufferCapacity(address, value);
    }
    private static native void _setConstraintBufferCapacity(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getContactBufferCapacity() {
        checkNotNull();
        return _getContactBufferCapacity(address);
    }
    private static native int _getContactBufferCapacity(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setContactBufferCapacity(int value) {
        checkNotNull();
        _setContactBufferCapacity(address, value);
    }
    private static native void _setContactBufferCapacity(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTempBufferCapacity() {
        checkNotNull();
        return _getTempBufferCapacity(address);
    }
    private static native int _getTempBufferCapacity(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setTempBufferCapacity(int value) {
        checkNotNull();
        _setTempBufferCapacity(address, value);
    }
    private static native void _setTempBufferCapacity(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getContactStreamSize() {
        checkNotNull();
        return _getContactStreamSize(address);
    }
    private static native int _getContactStreamSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setContactStreamSize(int value) {
        checkNotNull();
        _setContactStreamSize(address, value);
    }
    private static native void _setContactStreamSize(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getPatchStreamSize() {
        checkNotNull();
        return _getPatchStreamSize(address);
    }
    private static native int _getPatchStreamSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setPatchStreamSize(int value) {
        checkNotNull();
        _setPatchStreamSize(address, value);
    }
    private static native void _setPatchStreamSize(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getForceStreamCapacity() {
        checkNotNull();
        return _getForceStreamCapacity(address);
    }
    private static native int _getForceStreamCapacity(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setForceStreamCapacity(int value) {
        checkNotNull();
        _setForceStreamCapacity(address, value);
    }
    private static native void _setForceStreamCapacity(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getHeapCapacity() {
        checkNotNull();
        return _getHeapCapacity(address);
    }
    private static native int _getHeapCapacity(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setHeapCapacity(int value) {
        checkNotNull();
        _setHeapCapacity(address, value);
    }
    private static native void _setHeapCapacity(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getFoundLostPairsCapacity() {
        checkNotNull();
        return _getFoundLostPairsCapacity(address);
    }
    private static native int _getFoundLostPairsCapacity(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setFoundLostPairsCapacity(int value) {
        checkNotNull();
        _setFoundLostPairsCapacity(address, value);
    }
    private static native void _setFoundLostPairsCapacity(long address, int value);

}
