package physx.physics;

import physx.NativeObject;
import physx.common.PxBaseTask;
import physx.common.PxCollection;
import physx.common.PxCpuDispatcher;
import physx.common.PxCudaContextManager;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.geomutils.PxBVHStructure;
import physx.geomutils.PxGeometry;

public class PxScene extends NativeObject {

    protected PxScene() { }

    public static PxScene wrapPointer(long address) {
        return address != 0L ? new PxScene(address) : null;
    }
    
    protected PxScene(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject value) {
        checkNotNull();
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

    // Functions

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     */
    public void addActor(PxActor actor) {
        checkNotNull();
        _addActor(address, actor.getAddress());
    }
    private static native void _addActor(long address, long actor);

    /**
     * @param actor        WebIDL type: {@link PxActor} [Ref]
     * @param bvhStructure WebIDL type: {@link PxBVHStructure} [Const]
     */
    public void addActor(PxActor actor, PxBVHStructure bvhStructure) {
        checkNotNull();
        _addActor(address, actor.getAddress(), bvhStructure.getAddress());
    }
    private static native void _addActor(long address, long actor, long bvhStructure);

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     */
    public void removeActor(PxActor actor) {
        checkNotNull();
        _removeActor(address, actor.getAddress());
    }
    private static native void _removeActor(long address, long actor);

    /**
     * @param actor           WebIDL type: {@link PxActor} [Ref]
     * @param wakeOnLostTouch WebIDL type: boolean
     */
    public void removeActor(PxActor actor, boolean wakeOnLostTouch) {
        checkNotNull();
        _removeActor(address, actor.getAddress(), wakeOnLostTouch);
    }
    private static native void _removeActor(long address, long actor, boolean wakeOnLostTouch);

    /**
     * @param aggregate WebIDL type: {@link PxAggregate} [Ref]
     */
    public void addAggregate(PxAggregate aggregate) {
        checkNotNull();
        _addAggregate(address, aggregate.getAddress());
    }
    private static native void _addAggregate(long address, long aggregate);

    /**
     * @param aggregate WebIDL type: {@link PxAggregate} [Ref]
     */
    public void removeAggregate(PxAggregate aggregate) {
        checkNotNull();
        _removeAggregate(address, aggregate.getAddress());
    }
    private static native void _removeAggregate(long address, long aggregate);

    /**
     * @param aggregate       WebIDL type: {@link PxAggregate} [Ref]
     * @param wakeOnLostTouch WebIDL type: boolean
     */
    public void removeAggregate(PxAggregate aggregate, boolean wakeOnLostTouch) {
        checkNotNull();
        _removeAggregate(address, aggregate.getAddress(), wakeOnLostTouch);
    }
    private static native void _removeAggregate(long address, long aggregate, boolean wakeOnLostTouch);

    /**
     * @param collection WebIDL type: {@link PxCollection} [Const, Ref]
     */
    public void addCollection(PxCollection collection) {
        checkNotNull();
        _addCollection(address, collection.getAddress());
    }
    private static native void _addCollection(long address, long collection);

    /**
     * @return WebIDL type: float
     */
    public float getWakeCounterResetValue() {
        checkNotNull();
        return _getWakeCounterResetValue(address);
    }
    private static native float _getWakeCounterResetValue(long address);

    /**
     * @param shift WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void shiftOrigin(PxVec3 shift) {
        checkNotNull();
        _shiftOrigin(address, shift.getAddress());
    }
    private static native void _shiftOrigin(long address, long shift);

    /**
     * @param articulation WebIDL type: {@link PxArticulationBase} [Ref]
     */
    public void addArticulation(PxArticulationBase articulation) {
        checkNotNull();
        _addArticulation(address, articulation.getAddress());
    }
    private static native void _addArticulation(long address, long articulation);

    /**
     * @param articulation WebIDL type: {@link PxArticulationBase} [Ref]
     */
    public void removeArticulation(PxArticulationBase articulation) {
        checkNotNull();
        _removeArticulation(address, articulation.getAddress());
    }
    private static native void _removeArticulation(long address, long articulation);

    /**
     * @param articulation    WebIDL type: {@link PxArticulationBase} [Ref]
     * @param wakeOnLostTouch WebIDL type: boolean
     */
    public void removeArticulation(PxArticulationBase articulation, boolean wakeOnLostTouch) {
        checkNotNull();
        _removeArticulation(address, articulation.getAddress(), wakeOnLostTouch);
    }
    private static native void _removeArticulation(long address, long articulation, boolean wakeOnLostTouch);

    /**
     * @param types WebIDL type: {@link PxActorTypeFlags} [Ref]
     * @return WebIDL type: unsigned long
     */
    public int getNbActors(PxActorTypeFlags types) {
        checkNotNull();
        return _getNbActors(address, types.getAddress());
    }
    private static native int _getNbActors(long address, long types);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbArticulations() {
        checkNotNull();
        return _getNbArticulations(address);
    }
    private static native int _getNbArticulations(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbConstraints() {
        checkNotNull();
        return _getNbConstraints(address);
    }
    private static native int _getNbConstraints(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAggregates() {
        checkNotNull();
        return _getNbAggregates(address);
    }
    private static native int _getNbAggregates(long address);

    /**
     * @param group1    WebIDL type: octet
     * @param group2    WebIDL type: octet
     * @param dominance WebIDL type: {@link PxDominanceGroupPair} [Const, Ref]
     */
    public void setDominanceGroupPair(byte group1, byte group2, PxDominanceGroupPair dominance) {
        checkNotNull();
        _setDominanceGroupPair(address, group1, group2, dominance.getAddress());
    }
    private static native void _setDominanceGroupPair(long address, byte group1, byte group2, long dominance);

    /**
     * @return WebIDL type: {@link PxCpuDispatcher}
     */
    public PxCpuDispatcher getCpuDispatcher() {
        checkNotNull();
        return PxCpuDispatcher.wrapPointer(_getCpuDispatcher(address));
    }
    private static native long _getCpuDispatcher(long address);

    /**
     * @return WebIDL type: {@link PxCudaContextManager}
     */
    public PxCudaContextManager getCudaContextManager() {
        checkNotNull();
        return PxCudaContextManager.wrapPointer(_getCudaContextManager(address));
    }
    private static native long _getCudaContextManager(long address);

    /**
     * @return WebIDL type: octet
     */
    public byte createClient() {
        checkNotNull();
        return _createClient(address);
    }
    private static native byte _createClient(long address);

    /**
     * @param callback WebIDL type: {@link PxSimulationEventCallback}
     */
    public void setSimulationEventCallback(PxSimulationEventCallback callback) {
        checkNotNull();
        _setSimulationEventCallback(address, callback.getAddress());
    }
    private static native void _setSimulationEventCallback(long address, long callback);

    /**
     * @return WebIDL type: {@link PxSimulationEventCallback}
     */
    public PxSimulationEventCallback getSimulationEventCallback() {
        checkNotNull();
        return PxSimulationEventCallback.wrapPointer(_getSimulationEventCallback(address));
    }
    private static native long _getSimulationEventCallback(long address);

    /**
     * @param data     WebIDL type: VoidPtr [Const]
     * @param dataSize WebIDL type: unsigned long
     */
    public void setFilterShaderData(NativeObject data, int dataSize) {
        checkNotNull();
        _setFilterShaderData(address, data.getAddress(), dataSize);
    }
    private static native void _setFilterShaderData(long address, long data, int dataSize);

    /**
     * @return WebIDL type: VoidPtr [Const]
     */
    public NativeObject getFilterShaderData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getFilterShaderData(address));
    }
    private static native long _getFilterShaderData(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getFilterShaderDataSize() {
        checkNotNull();
        return _getFilterShaderDataSize(address);
    }
    private static native int _getFilterShaderDataSize(long address);

    /**
     * @return WebIDL type: {@link PxSimulationFilterShader} [Value]
     */
    public PxSimulationFilterShader getFilterShader() {
        checkNotNull();
        return PxSimulationFilterShader.wrapPointer(_getFilterShader(address));
    }
    private static native long _getFilterShader(long address);

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     */
    public void resetFiltering(PxActor actor) {
        checkNotNull();
        _resetFiltering(address, actor.getAddress());
    }
    private static native void _resetFiltering(long address, long actor);

    /**
     * @return WebIDL type: {@link PxPairFilteringModeEnum} [enum]
     */
    public int getKinematicKinematicFilteringMode() {
        checkNotNull();
        return _getKinematicKinematicFilteringMode(address);
    }
    private static native int _getKinematicKinematicFilteringMode(long address);

    /**
     * @return WebIDL type: {@link PxPairFilteringModeEnum} [enum]
     */
    public int getStaticKinematicFilteringMode() {
        checkNotNull();
        return _getStaticKinematicFilteringMode(address);
    }
    private static native int _getStaticKinematicFilteringMode(long address);

    /**
     * @param elapsedTime WebIDL type: float
     */
    public void simulate(float elapsedTime) {
        checkNotNull();
        _simulate(address, elapsedTime);
    }
    private static native void _simulate(long address, float elapsedTime);

    /**
     * @param elapsedTime    WebIDL type: float
     * @param completionTask WebIDL type: {@link PxBaseTask}
     */
    public void simulate(float elapsedTime, PxBaseTask completionTask) {
        checkNotNull();
        _simulate(address, elapsedTime, completionTask.getAddress());
    }
    private static native void _simulate(long address, float elapsedTime, long completionTask);

    /**
     * @param elapsedTime     WebIDL type: float
     * @param completionTask  WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock WebIDL type: VoidPtr
     */
    public void simulate(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock) {
        checkNotNull();
        _simulate(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress());
    }
    private static native void _simulate(long address, float elapsedTime, long completionTask, long scratchMemBlock);

    /**
     * @param elapsedTime         WebIDL type: float
     * @param completionTask      WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock     WebIDL type: VoidPtr
     * @param scratchMemBlockSize WebIDL type: unsigned long
     */
    public void simulate(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize) {
        checkNotNull();
        _simulate(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize);
    }
    private static native void _simulate(long address, float elapsedTime, long completionTask, long scratchMemBlock, int scratchMemBlockSize);

    /**
     * @param elapsedTime         WebIDL type: float
     * @param completionTask      WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock     WebIDL type: VoidPtr
     * @param scratchMemBlockSize WebIDL type: unsigned long
     * @param controlSimulation   WebIDL type: boolean
     */
    public void simulate(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize, boolean controlSimulation) {
        checkNotNull();
        _simulate(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize, controlSimulation);
    }
    private static native void _simulate(long address, float elapsedTime, long completionTask, long scratchMemBlock, int scratchMemBlockSize, boolean controlSimulation);

    public void advance() {
        checkNotNull();
        _advance(address);
    }
    private static native void _advance(long address);

    /**
     * @param completionTask WebIDL type: {@link PxBaseTask}
     */
    public void advance(PxBaseTask completionTask) {
        checkNotNull();
        _advance(address, completionTask.getAddress());
    }
    private static native void _advance(long address, long completionTask);

    /**
     * @param elapsedTime WebIDL type: float
     */
    public void collide(float elapsedTime) {
        checkNotNull();
        _collide(address, elapsedTime);
    }
    private static native void _collide(long address, float elapsedTime);

    /**
     * @param elapsedTime    WebIDL type: float
     * @param completionTask WebIDL type: {@link PxBaseTask}
     */
    public void collide(float elapsedTime, PxBaseTask completionTask) {
        checkNotNull();
        _collide(address, elapsedTime, completionTask.getAddress());
    }
    private static native void _collide(long address, float elapsedTime, long completionTask);

    /**
     * @param elapsedTime     WebIDL type: float
     * @param completionTask  WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock WebIDL type: VoidPtr
     */
    public void collide(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock) {
        checkNotNull();
        _collide(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress());
    }
    private static native void _collide(long address, float elapsedTime, long completionTask, long scratchMemBlock);

    /**
     * @param elapsedTime         WebIDL type: float
     * @param completionTask      WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock     WebIDL type: VoidPtr
     * @param scratchMemBlockSize WebIDL type: unsigned long
     */
    public void collide(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize) {
        checkNotNull();
        _collide(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize);
    }
    private static native void _collide(long address, float elapsedTime, long completionTask, long scratchMemBlock, int scratchMemBlockSize);

    /**
     * @param elapsedTime         WebIDL type: float
     * @param completionTask      WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock     WebIDL type: VoidPtr
     * @param scratchMemBlockSize WebIDL type: unsigned long
     * @param controlSimulation   WebIDL type: boolean
     */
    public void collide(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize, boolean controlSimulation) {
        checkNotNull();
        _collide(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize, controlSimulation);
    }
    private static native void _collide(long address, float elapsedTime, long completionTask, long scratchMemBlock, int scratchMemBlockSize, boolean controlSimulation);

    /**
     * @return WebIDL type: boolean
     */
    public boolean checkResults() {
        checkNotNull();
        return _checkResults(address);
    }
    private static native boolean _checkResults(long address);

    /**
     * @param block WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean checkResults(boolean block) {
        checkNotNull();
        return _checkResults(address, block);
    }
    private static native boolean _checkResults(long address, boolean block);

    /**
     * @return WebIDL type: boolean
     */
    public boolean fetchCollision() {
        checkNotNull();
        return _fetchCollision(address);
    }
    private static native boolean _fetchCollision(long address);

    /**
     * @param block WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean fetchCollision(boolean block) {
        checkNotNull();
        return _fetchCollision(address, block);
    }
    private static native boolean _fetchCollision(long address, boolean block);

    /**
     * @return WebIDL type: boolean
     */
    public boolean fetchResults() {
        checkNotNull();
        return _fetchResults(address);
    }
    private static native boolean _fetchResults(long address);

    /**
     * @param block WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean fetchResults(boolean block) {
        checkNotNull();
        return _fetchResults(address, block);
    }
    private static native boolean _fetchResults(long address, boolean block);

    /**
     * @param continuation WebIDL type: {@link PxBaseTask}
     */
    public void processCallbacks(PxBaseTask continuation) {
        checkNotNull();
        _processCallbacks(address, continuation.getAddress());
    }
    private static native void _processCallbacks(long address, long continuation);

    public void flushSimulation() {
        checkNotNull();
        _flushSimulation(address);
    }
    private static native void _flushSimulation(long address);

    /**
     * @param sendPendingReports WebIDL type: boolean
     */
    public void flushSimulation(boolean sendPendingReports) {
        checkNotNull();
        _flushSimulation(address, sendPendingReports);
    }
    private static native void _flushSimulation(long address, boolean sendPendingReports);

    /**
     * @param vec WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setGravity(PxVec3 vec) {
        checkNotNull();
        _setGravity(address, vec.getAddress());
    }
    private static native void _setGravity(long address, long vec);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getGravity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getGravity(address));
    }
    private static native long _getGravity(long address);

    /**
     * @param t WebIDL type: float
     */
    public void setBounceThresholdVelocity(float t) {
        checkNotNull();
        _setBounceThresholdVelocity(address, t);
    }
    private static native void _setBounceThresholdVelocity(long address, float t);

    /**
     * @return WebIDL type: float
     */
    public float getBounceThresholdVelocity() {
        checkNotNull();
        return _getBounceThresholdVelocity(address);
    }
    private static native float _getBounceThresholdVelocity(long address);

    /**
     * @param ccdMaxPasses WebIDL type: unsigned long
     */
    public void setCCDMaxPasses(int ccdMaxPasses) {
        checkNotNull();
        _setCCDMaxPasses(address, ccdMaxPasses);
    }
    private static native void _setCCDMaxPasses(long address, int ccdMaxPasses);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCCDMaxPasses() {
        checkNotNull();
        return _getCCDMaxPasses(address);
    }
    private static native int _getCCDMaxPasses(long address);

    /**
     * @return WebIDL type: float
     */
    public float getFrictionOffsetThreshold() {
        checkNotNull();
        return _getFrictionOffsetThreshold(address);
    }
    private static native float _getFrictionOffsetThreshold(long address);

    /**
     * @param frictionType WebIDL type: {@link PxFrictionTypeEnum} [enum]
     */
    public void setFrictionType(int frictionType) {
        checkNotNull();
        _setFrictionType(address, frictionType);
    }
    private static native void _setFrictionType(long address, int frictionType);

    /**
     * @return WebIDL type: {@link PxFrictionTypeEnum} [enum]
     */
    public int getFrictionType() {
        checkNotNull();
        return _getFrictionType(address);
    }
    private static native int _getFrictionType(long address);

    /**
     * @param stats WebIDL type: {@link PxSimulationStatistics} [Ref]
     */
    public void getSimulationStatistics(PxSimulationStatistics stats) {
        checkNotNull();
        _getSimulationStatistics(address, stats.getAddress());
    }
    private static native void _getSimulationStatistics(long address, long stats);

    /**
     * @return WebIDL type: {@link PxPruningStructureTypeEnum} [enum]
     */
    public int getStaticStructure() {
        checkNotNull();
        return _getStaticStructure(address);
    }
    private static native int _getStaticStructure(long address);

    /**
     * @return WebIDL type: {@link PxPruningStructureTypeEnum} [enum]
     */
    public int getDynamicStructure() {
        checkNotNull();
        return _getDynamicStructure(address);
    }
    private static native int _getDynamicStructure(long address);

    public void flushQueryUpdates() {
        checkNotNull();
        _flushQueryUpdates(address);
    }
    private static native void _flushQueryUpdates(long address);

    /**
     * @param desc WebIDL type: {@link PxBatchQueryDesc} [Const, Ref]
     * @return WebIDL type: {@link PxBatchQuery}
     */
    public PxBatchQuery createBatchQuery(PxBatchQueryDesc desc) {
        checkNotNull();
        return PxBatchQuery.wrapPointer(_createBatchQuery(address, desc.getAddress()));
    }
    private static native long _createBatchQuery(long address, long desc);

    /**
     * @param dynamicTreeRebuildRateHint WebIDL type: unsigned long
     */
    public void setDynamicTreeRebuildRateHint(int dynamicTreeRebuildRateHint) {
        checkNotNull();
        _setDynamicTreeRebuildRateHint(address, dynamicTreeRebuildRateHint);
    }
    private static native void _setDynamicTreeRebuildRateHint(long address, int dynamicTreeRebuildRateHint);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getDynamicTreeRebuildRateHint() {
        checkNotNull();
        return _getDynamicTreeRebuildRateHint(address);
    }
    private static native int _getDynamicTreeRebuildRateHint(long address);

    /**
     * @param rebuildStaticStructure  WebIDL type: boolean
     * @param rebuildDynamicStructure WebIDL type: boolean
     */
    public void forceDynamicTreeRebuild(boolean rebuildStaticStructure, boolean rebuildDynamicStructure) {
        checkNotNull();
        _forceDynamicTreeRebuild(address, rebuildStaticStructure, rebuildDynamicStructure);
    }
    private static native void _forceDynamicTreeRebuild(long address, boolean rebuildStaticStructure, boolean rebuildDynamicStructure);

    /**
     * @param updateMode WebIDL type: {@link PxSceneQueryUpdateModeEnum} [enum]
     */
    public void setSceneQueryUpdateMode(int updateMode) {
        checkNotNull();
        _setSceneQueryUpdateMode(address, updateMode);
    }
    private static native void _setSceneQueryUpdateMode(long address, int updateMode);

    /**
     * @return WebIDL type: {@link PxSceneQueryUpdateModeEnum} [enum]
     */
    public int getSceneQueryUpdateMode() {
        checkNotNull();
        return _getSceneQueryUpdateMode(address);
    }
    private static native int _getSceneQueryUpdateMode(long address);

    public void sceneQueriesUpdate() {
        checkNotNull();
        _sceneQueriesUpdate(address);
    }
    private static native void _sceneQueriesUpdate(long address);

    /**
     * @param completionTask WebIDL type: {@link PxBaseTask}
     */
    public void sceneQueriesUpdate(PxBaseTask completionTask) {
        checkNotNull();
        _sceneQueriesUpdate(address, completionTask.getAddress());
    }
    private static native void _sceneQueriesUpdate(long address, long completionTask);

    /**
     * @param completionTask    WebIDL type: {@link PxBaseTask}
     * @param controlSimulation WebIDL type: boolean
     */
    public void sceneQueriesUpdate(PxBaseTask completionTask, boolean controlSimulation) {
        checkNotNull();
        _sceneQueriesUpdate(address, completionTask.getAddress(), controlSimulation);
    }
    private static native void _sceneQueriesUpdate(long address, long completionTask, boolean controlSimulation);

    /**
     * @return WebIDL type: boolean
     */
    public boolean checkQueries() {
        checkNotNull();
        return _checkQueries(address);
    }
    private static native boolean _checkQueries(long address);

    /**
     * @param block WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean checkQueries(boolean block) {
        checkNotNull();
        return _checkQueries(address, block);
    }
    private static native boolean _checkQueries(long address, boolean block);

    /**
     * @return WebIDL type: boolean
     */
    public boolean fetchQueries() {
        checkNotNull();
        return _fetchQueries(address);
    }
    private static native boolean _fetchQueries(long address);

    /**
     * @param block WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean fetchQueries(boolean block) {
        checkNotNull();
        return _fetchQueries(address, block);
    }
    private static native boolean _fetchQueries(long address, boolean block);

    /**
     * @param origin   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance WebIDL type: float
     * @param hitCall  WebIDL type: {@link PxRaycastCallback} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean raycast(PxVec3 origin, PxVec3 unitDir, float distance, PxRaycastCallback hitCall) {
        checkNotNull();
        return _raycast(address, origin.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress());
    }
    private static native boolean _raycast(long address, long origin, long unitDir, float distance, long hitCall);

    /**
     * @param origin   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance WebIDL type: float
     * @param hitCall  WebIDL type: {@link PxRaycastCallback} [Ref]
     * @param hitFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean raycast(PxVec3 origin, PxVec3 unitDir, float distance, PxRaycastCallback hitCall, PxHitFlags hitFlags) {
        checkNotNull();
        return _raycast(address, origin.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress(), hitFlags.getAddress());
    }
    private static native boolean _raycast(long address, long origin, long unitDir, float distance, long hitCall, long hitFlags);

    /**
     * @param origin     WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance   WebIDL type: float
     * @param hitCall    WebIDL type: {@link PxRaycastCallback} [Ref]
     * @param hitFlags   WebIDL type: {@link PxHitFlags} [Ref]
     * @param filterData WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean raycast(PxVec3 origin, PxVec3 unitDir, float distance, PxRaycastCallback hitCall, PxHitFlags hitFlags, PxQueryFilterData filterData) {
        checkNotNull();
        return _raycast(address, origin.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress(), hitFlags.getAddress(), filterData.getAddress());
    }
    private static native boolean _raycast(long address, long origin, long unitDir, float distance, long hitCall, long hitFlags, long filterData);

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance WebIDL type: float
     * @param hitCall  WebIDL type: {@link PxSweepCallback} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean sweep(PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxSweepCallback hitCall) {
        checkNotNull();
        return _sweep(address, geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress());
    }
    private static native boolean _sweep(long address, long geometry, long pose, long unitDir, float distance, long hitCall);

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance WebIDL type: float
     * @param hitCall  WebIDL type: {@link PxSweepCallback} [Ref]
     * @param hitFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean sweep(PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxSweepCallback hitCall, PxHitFlags hitFlags) {
        checkNotNull();
        return _sweep(address, geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress(), hitFlags.getAddress());
    }
    private static native boolean _sweep(long address, long geometry, long pose, long unitDir, float distance, long hitCall, long hitFlags);

    /**
     * @param geometry   WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose       WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance   WebIDL type: float
     * @param hitCall    WebIDL type: {@link PxSweepCallback} [Ref]
     * @param hitFlags   WebIDL type: {@link PxHitFlags} [Ref]
     * @param filterData WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean sweep(PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxSweepCallback hitCall, PxHitFlags hitFlags, PxQueryFilterData filterData) {
        checkNotNull();
        return _sweep(address, geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress(), hitFlags.getAddress(), filterData.getAddress());
    }
    private static native boolean _sweep(long address, long geometry, long pose, long unitDir, float distance, long hitCall, long hitFlags, long filterData);

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param hitCall  WebIDL type: {@link PxOverlapCallback} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean overlap(PxGeometry geometry, PxTransform pose, PxOverlapCallback hitCall) {
        checkNotNull();
        return _overlap(address, geometry.getAddress(), pose.getAddress(), hitCall.getAddress());
    }
    private static native boolean _overlap(long address, long geometry, long pose, long hitCall);

    /**
     * @param geometry   WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose       WebIDL type: {@link PxTransform} [Const, Ref]
     * @param hitCall    WebIDL type: {@link PxOverlapCallback} [Ref]
     * @param filterData WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean overlap(PxGeometry geometry, PxTransform pose, PxOverlapCallback hitCall, PxQueryFilterData filterData) {
        checkNotNull();
        return _overlap(address, geometry.getAddress(), pose.getAddress(), hitCall.getAddress(), filterData.getAddress());
    }
    private static native boolean _overlap(long address, long geometry, long pose, long hitCall, long filterData);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getSceneQueryStaticTimestamp() {
        checkNotNull();
        return _getSceneQueryStaticTimestamp(address);
    }
    private static native int _getSceneQueryStaticTimestamp(long address);

    /**
     * @return WebIDL type: {@link PxBroadPhaseTypeEnum} [enum]
     */
    public int getBroadPhaseType() {
        checkNotNull();
        return _getBroadPhaseType(address);
    }
    private static native int _getBroadPhaseType(long address);

    /**
     * @param caps WebIDL type: {@link PxBroadPhaseCaps} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean getBroadPhaseCaps(PxBroadPhaseCaps caps) {
        checkNotNull();
        return _getBroadPhaseCaps(address, caps.getAddress());
    }
    private static native boolean _getBroadPhaseCaps(long address, long caps);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbBroadPhaseRegions() {
        checkNotNull();
        return _getNbBroadPhaseRegions(address);
    }
    private static native int _getNbBroadPhaseRegions(long address);

    /**
     * @param userBuffer WebIDL type: {@link PxBroadPhaseRegionInfo}
     * @param bufferSize WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getBroadPhaseRegions(PxBroadPhaseRegionInfo userBuffer, int bufferSize) {
        checkNotNull();
        return _getBroadPhaseRegions(address, userBuffer.getAddress(), bufferSize);
    }
    private static native int _getBroadPhaseRegions(long address, long userBuffer, int bufferSize);

    /**
     * @param userBuffer WebIDL type: {@link PxBroadPhaseRegionInfo}
     * @param bufferSize WebIDL type: unsigned long
     * @param startIndex WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getBroadPhaseRegions(PxBroadPhaseRegionInfo userBuffer, int bufferSize, int startIndex) {
        checkNotNull();
        return _getBroadPhaseRegions(address, userBuffer.getAddress(), bufferSize, startIndex);
    }
    private static native int _getBroadPhaseRegions(long address, long userBuffer, int bufferSize, int startIndex);

    /**
     * @param region WebIDL type: {@link PxBroadPhaseRegion} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int addBroadPhaseRegion(PxBroadPhaseRegion region) {
        checkNotNull();
        return _addBroadPhaseRegion(address, region.getAddress());
    }
    private static native int _addBroadPhaseRegion(long address, long region);

    /**
     * @param region         WebIDL type: {@link PxBroadPhaseRegion} [Const, Ref]
     * @param populateRegion WebIDL type: boolean
     * @return WebIDL type: unsigned long
     */
    public int addBroadPhaseRegion(PxBroadPhaseRegion region, boolean populateRegion) {
        checkNotNull();
        return _addBroadPhaseRegion(address, region.getAddress(), populateRegion);
    }
    private static native int _addBroadPhaseRegion(long address, long region, boolean populateRegion);

    /**
     * @param handle WebIDL type: unsigned long
     * @return WebIDL type: boolean
     */
    public boolean removeBroadPhaseRegion(int handle) {
        checkNotNull();
        return _removeBroadPhaseRegion(address, handle);
    }
    private static native boolean _removeBroadPhaseRegion(long address, int handle);

    public void lockRead() {
        checkNotNull();
        _lockRead(address);
    }
    private static native void _lockRead(long address);

    /**
     * @param file WebIDL type: DOMString
     */
    public void lockRead(String file) {
        checkNotNull();
        _lockRead(address, file);
    }
    private static native void _lockRead(long address, String file);

    /**
     * @param file WebIDL type: DOMString
     * @param line WebIDL type: unsigned long
     */
    public void lockRead(String file, int line) {
        checkNotNull();
        _lockRead(address, file, line);
    }
    private static native void _lockRead(long address, String file, int line);

    public void unlockRead() {
        checkNotNull();
        _unlockRead(address);
    }
    private static native void _unlockRead(long address);

    public void lockWrite() {
        checkNotNull();
        _lockWrite(address);
    }
    private static native void _lockWrite(long address);

    /**
     * @param file WebIDL type: DOMString
     */
    public void lockWrite(String file) {
        checkNotNull();
        _lockWrite(address, file);
    }
    private static native void _lockWrite(long address, String file);

    /**
     * @param file WebIDL type: DOMString
     * @param line WebIDL type: unsigned long
     */
    public void lockWrite(String file, int line) {
        checkNotNull();
        _lockWrite(address, file, line);
    }
    private static native void _lockWrite(long address, String file, int line);

    public void unlockWrite() {
        checkNotNull();
        _unlockWrite(address);
    }
    private static native void _unlockWrite(long address);

    /**
     * @param numBlocks WebIDL type: unsigned long
     */
    public void setNbContactDataBlocks(int numBlocks) {
        checkNotNull();
        _setNbContactDataBlocks(address, numBlocks);
    }
    private static native void _setNbContactDataBlocks(long address, int numBlocks);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbContactDataBlocksUsed() {
        checkNotNull();
        return _getNbContactDataBlocksUsed(address);
    }
    private static native int _getNbContactDataBlocksUsed(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbContactDataBlocksUsed() {
        checkNotNull();
        return _getMaxNbContactDataBlocksUsed(address);
    }
    private static native int _getMaxNbContactDataBlocksUsed(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getContactReportStreamBufferSize() {
        checkNotNull();
        return _getContactReportStreamBufferSize(address);
    }
    private static native int _getContactReportStreamBufferSize(long address);

    /**
     * @param solverBatchSize WebIDL type: unsigned long
     */
    public void setSolverBatchSize(int solverBatchSize) {
        checkNotNull();
        _setSolverBatchSize(address, solverBatchSize);
    }
    private static native void _setSolverBatchSize(long address, int solverBatchSize);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getSolverBatchSize() {
        checkNotNull();
        return _getSolverBatchSize(address);
    }
    private static native int _getSolverBatchSize(long address);

    /**
     * @param solverBatchSize WebIDL type: unsigned long
     */
    public void setSolverArticulationBatchSize(int solverBatchSize) {
        checkNotNull();
        _setSolverArticulationBatchSize(address, solverBatchSize);
    }
    private static native void _setSolverArticulationBatchSize(long address, int solverBatchSize);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getSolverArticulationBatchSize() {
        checkNotNull();
        return _getSolverArticulationBatchSize(address);
    }
    private static native int _getSolverArticulationBatchSize(long address);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @param flag  WebIDL type: {@link PxSceneFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setFlag(int flag, boolean value) {
        checkNotNull();
        _setFlag(address, flag, value);
    }
    private static native void _setFlag(long address, int flag, boolean value);

    /**
     * @return WebIDL type: {@link PxSceneFlags} [Value]
     */
    public PxSceneFlags getFlags() {
        checkNotNull();
        return PxSceneFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param limits WebIDL type: {@link PxSceneLimits} [Const, Ref]
     */
    public void setLimits(PxSceneLimits limits) {
        checkNotNull();
        _setLimits(address, limits.getAddress());
    }
    private static native void _setLimits(long address, long limits);

    /**
     * @return WebIDL type: {@link PxSceneLimits} [Value]
     */
    public PxSceneLimits getLimits() {
        checkNotNull();
        return PxSceneLimits.wrapPointer(_getLimits(address));
    }
    private static native long _getLimits(long address);

    /**
     * @return WebIDL type: {@link PxPhysics} [Ref]
     */
    public PxPhysics getPhysics() {
        checkNotNull();
        return PxPhysics.wrapPointer(_getPhysics(address));
    }
    private static native long _getPhysics(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTimestamp() {
        checkNotNull();
        return _getTimestamp(address);
    }
    private static native int _getTimestamp(long address);

}
