package physx.physics;

import physx.common.PxTransform;
import physx.extensions.PxJoint;
import physx.support.PxRealPtr;

public class PxArticulationReducedCoordinate extends PxArticulationBase {

    protected PxArticulationReducedCoordinate() { }

    public static PxArticulationReducedCoordinate wrapPointer(long address) {
        return address != 0L ? new PxArticulationReducedCoordinate(address) : null;
    }
    
    protected PxArticulationReducedCoordinate(long address) {
        super(address);
    }

    // Functions

    /**
     * @param flags WebIDL type: {@link PxArticulationFlags} [Ref]
     */
    public void setArticulationFlags(PxArticulationFlags flags) {
        checkNotNull();
        _setArticulationFlags(address, flags.getAddress());
    }
    private static native void _setArticulationFlags(long address, long flags);

    /**
     * @param flag  WebIDL type: {@link PxArticulationFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setArticulationFlag(int flag, boolean value) {
        checkNotNull();
        _setArticulationFlag(address, flag, value);
    }
    private static native void _setArticulationFlag(long address, int flag, boolean value);

    /**
     * @return WebIDL type: {@link PxArticulationFlags} [Value]
     */
    public PxArticulationFlags getArticulationFlags() {
        checkNotNull();
        return PxArticulationFlags.wrapPointer(_getArticulationFlags(address));
    }
    private static native long _getArticulationFlags(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getDofs() {
        checkNotNull();
        return _getDofs(address);
    }
    private static native int _getDofs(long address);

    /**
     * @return WebIDL type: {@link PxArticulationCache}
     */
    public PxArticulationCache createCache() {
        checkNotNull();
        return PxArticulationCache.wrapPointer(_createCache(address));
    }
    private static native long _createCache(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCacheDataSize() {
        checkNotNull();
        return _getCacheDataSize(address);
    }
    private static native int _getCacheDataSize(long address);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void zeroCache(PxArticulationCache cache) {
        checkNotNull();
        _zeroCache(address, cache.getAddress());
    }
    private static native void _zeroCache(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     * @param flag  WebIDL type: {@link PxArticulationCacheFlags} [Const, Ref]
     */
    public void applyCache(PxArticulationCache cache, PxArticulationCacheFlags flag) {
        checkNotNull();
        _applyCache(address, cache.getAddress(), flag.getAddress());
    }
    private static native void _applyCache(long address, long cache, long flag);

    /**
     * @param cache    WebIDL type: {@link PxArticulationCache} [Ref]
     * @param flag     WebIDL type: {@link PxArticulationCacheFlags} [Const, Ref]
     * @param autowake WebIDL type: boolean
     */
    public void applyCache(PxArticulationCache cache, PxArticulationCacheFlags flag, boolean autowake) {
        checkNotNull();
        _applyCache(address, cache.getAddress(), flag.getAddress(), autowake);
    }
    private static native void _applyCache(long address, long cache, long flag, boolean autowake);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     * @param flag  WebIDL type: {@link PxArticulationCacheFlags} [Const, Ref]
     */
    public void copyInternalStateToCache(PxArticulationCache cache, PxArticulationCacheFlags flag) {
        checkNotNull();
        _copyInternalStateToCache(address, cache.getAddress(), flag.getAddress());
    }
    private static native void _copyInternalStateToCache(long address, long cache, long flag);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void releaseCache(PxArticulationCache cache) {
        checkNotNull();
        _releaseCache(address, cache.getAddress());
    }
    private static native void _releaseCache(long address, long cache);

    /**
     * @param maximum WebIDL type: {@link PxRealPtr} [Ref]
     * @param reduced WebIDL type: {@link PxRealPtr} [Ref]
     */
    public void packJointData(PxRealPtr maximum, PxRealPtr reduced) {
        checkNotNull();
        _packJointData(address, maximum.getAddress(), reduced.getAddress());
    }
    private static native void _packJointData(long address, long maximum, long reduced);

    /**
     * @param reduced WebIDL type: {@link PxRealPtr} [Ref]
     * @param maximum WebIDL type: {@link PxRealPtr} [Ref]
     */
    public void unpackJointData(PxRealPtr reduced, PxRealPtr maximum) {
        checkNotNull();
        _unpackJointData(address, reduced.getAddress(), maximum.getAddress());
    }
    private static native void _unpackJointData(long address, long reduced, long maximum);

    public void commonInit() {
        checkNotNull();
        _commonInit(address);
    }
    private static native void _commonInit(long address);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeGeneralizedGravityForce(PxArticulationCache cache) {
        checkNotNull();
        _computeGeneralizedGravityForce(address, cache.getAddress());
    }
    private static native void _computeGeneralizedGravityForce(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeCoriolisAndCentrifugalForce(PxArticulationCache cache) {
        checkNotNull();
        _computeCoriolisAndCentrifugalForce(address, cache.getAddress());
    }
    private static native void _computeCoriolisAndCentrifugalForce(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeGeneralizedExternalForce(PxArticulationCache cache) {
        checkNotNull();
        _computeGeneralizedExternalForce(address, cache.getAddress());
    }
    private static native void _computeGeneralizedExternalForce(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeJointAcceleration(PxArticulationCache cache) {
        checkNotNull();
        _computeJointAcceleration(address, cache.getAddress());
    }
    private static native void _computeJointAcceleration(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeJointForce(PxArticulationCache cache) {
        checkNotNull();
        _computeJointForce(address, cache.getAddress());
    }
    private static native void _computeJointForce(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeCoefficientMatrix(PxArticulationCache cache) {
        checkNotNull();
        _computeCoefficientMatrix(address, cache.getAddress());
    }
    private static native void _computeCoefficientMatrix(long address, long cache);

    /**
     * @param cache        WebIDL type: {@link PxArticulationCache} [Ref]
     * @param initialState WebIDL type: {@link PxArticulationCache} [Ref]
     * @param jointTorque  WebIDL type: {@link PxRealPtr} [Ref]
     * @param maxIter      WebIDL type: unsigned long
     */
    public void computeLambda(PxArticulationCache cache, PxArticulationCache initialState, PxRealPtr jointTorque, int maxIter) {
        checkNotNull();
        _computeLambda(address, cache.getAddress(), initialState.getAddress(), jointTorque.getAddress(), maxIter);
    }
    private static native void _computeLambda(long address, long cache, long initialState, long jointTorque, int maxIter);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeGeneralizedMassMatrix(PxArticulationCache cache) {
        checkNotNull();
        _computeGeneralizedMassMatrix(address, cache.getAddress());
    }
    private static native void _computeGeneralizedMassMatrix(long address, long cache);

    /**
     * @param joint WebIDL type: {@link PxJoint}
     */
    public void addLoopJoint(PxJoint joint) {
        checkNotNull();
        _addLoopJoint(address, joint.getAddress());
    }
    private static native void _addLoopJoint(long address, long joint);

    /**
     * @param joint WebIDL type: {@link PxJoint}
     */
    public void removeLoopJoint(PxJoint joint) {
        checkNotNull();
        _removeLoopJoint(address, joint.getAddress());
    }
    private static native void _removeLoopJoint(long address, long joint);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbLoopJoints() {
        checkNotNull();
        return _getNbLoopJoints(address);
    }
    private static native int _getNbLoopJoints(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCoefficientMatrixSize() {
        checkNotNull();
        return _getCoefficientMatrixSize(address);
    }
    private static native int _getCoefficientMatrixSize(long address);

    /**
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param autowake WebIDL type: boolean
     */
    public void teleportRootLink(PxTransform pose, boolean autowake) {
        checkNotNull();
        _teleportRootLink(address, pose.getAddress(), autowake);
    }
    private static native void _teleportRootLink(long address, long pose, boolean autowake);

    /**
     * @param linkId WebIDL type: unsigned long
     * @return WebIDL type: {@link PxSpatialVelocity} [Value]
     */
    public PxSpatialVelocity getLinkVelocity(int linkId) {
        checkNotNull();
        return PxSpatialVelocity.wrapPointer(_getLinkVelocity(address, linkId));
    }
    private static native long _getLinkVelocity(long address, int linkId);

    /**
     * @param linkId WebIDL type: unsigned long
     * @return WebIDL type: {@link PxSpatialVelocity} [Value]
     */
    public PxSpatialVelocity getLinkAcceleration(int linkId) {
        checkNotNull();
        return PxSpatialVelocity.wrapPointer(_getLinkAcceleration(address, linkId));
    }
    private static native long _getLinkAcceleration(long address, int linkId);

}
