package physx.geomutils;

import physx.NativeObject;

public class PxHeightFieldSample extends NativeObject {

    protected PxHeightFieldSample() { }

    public static PxHeightFieldSample wrapPointer(long address) {
        return address != 0L ? new PxHeightFieldSample(address) : null;
    }
    
    protected PxHeightFieldSample(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: short
     */
    public short getHeight() {
        checkNotNull();
        return _getHeight(address);
    }
    private static native short _getHeight(long address);

    /**
     * @param value WebIDL type: short
     */
    public void setHeight(short value) {
        checkNotNull();
        _setHeight(address, value);
    }
    private static native void _setHeight(long address, short value);

    /**
     * @return WebIDL type: octet
     */
    public byte getMaterialIndex0() {
        checkNotNull();
        return _getMaterialIndex0(address);
    }
    private static native byte _getMaterialIndex0(long address);

    /**
     * @param value WebIDL type: octet
     */
    public void setMaterialIndex0(byte value) {
        checkNotNull();
        _setMaterialIndex0(address, value);
    }
    private static native void _setMaterialIndex0(long address, byte value);

    /**
     * @return WebIDL type: octet
     */
    public byte getMaterialIndex1() {
        checkNotNull();
        return _getMaterialIndex1(address);
    }
    private static native byte _getMaterialIndex1(long address);

    /**
     * @param value WebIDL type: octet
     */
    public void setMaterialIndex1(byte value) {
        checkNotNull();
        _setMaterialIndex1(address, value);
    }
    private static native void _setMaterialIndex1(long address, byte value);

}
