package physx.extensions;

import physx.NativeObject;
import physx.common.PxFoundation;
import physx.physics.PxBatchQueryPostFilterShader;
import physx.physics.PxBatchQueryPreFilterShader;
import physx.physics.PxScene;
import physx.vehicle.PxVehicleDrivableSurfaceToTireFrictionPairs;

public class BatchVehicleUpdateDesc extends NativeObject {

    public static BatchVehicleUpdateDesc wrapPointer(long address) {
        return address != 0L ? new BatchVehicleUpdateDesc(address) : null;
    }
    
    protected BatchVehicleUpdateDesc(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of BatchVehicleUpdateDesc
     */
    public static BatchVehicleUpdateDesc createAt(long address) {
        __placement_new_BatchVehicleUpdateDesc(address);
        BatchVehicleUpdateDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of BatchVehicleUpdateDesc
     */
    public static <T> BatchVehicleUpdateDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_BatchVehicleUpdateDesc(address);
        BatchVehicleUpdateDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_BatchVehicleUpdateDesc(long address);

    // Constructors

    public BatchVehicleUpdateDesc() {
        address = _BatchVehicleUpdateDesc();
    }
    private static native long _BatchVehicleUpdateDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxFoundation}
     */
    public PxFoundation getFoundation() {
        checkNotNull();
        return PxFoundation.wrapPointer(_getFoundation(address));
    }
    private static native long _getFoundation(long address);

    /**
     * @param value WebIDL type: {@link PxFoundation}
     */
    public void setFoundation(PxFoundation value) {
        checkNotNull();
        _setFoundation(address, value.getAddress());
    }
    private static native void _setFoundation(long address, long value);

    /**
     * @return WebIDL type: {@link PxScene}
     */
    public PxScene getScene() {
        checkNotNull();
        return PxScene.wrapPointer(_getScene(address));
    }
    private static native long _getScene(long address);

    /**
     * @param value WebIDL type: {@link PxScene}
     */
    public void setScene(PxScene value) {
        checkNotNull();
        _setScene(address, value.getAddress());
    }
    private static native void _setScene(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleDrivableSurfaceToTireFrictionPairs}
     */
    public PxVehicleDrivableSurfaceToTireFrictionPairs getFrictionPairs() {
        checkNotNull();
        return PxVehicleDrivableSurfaceToTireFrictionPairs.wrapPointer(_getFrictionPairs(address));
    }
    private static native long _getFrictionPairs(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleDrivableSurfaceToTireFrictionPairs}
     */
    public void setFrictionPairs(PxVehicleDrivableSurfaceToTireFrictionPairs value) {
        checkNotNull();
        _setFrictionPairs(address, value.getAddress());
    }
    private static native void _setFrictionPairs(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbVehicles() {
        checkNotNull();
        return _getMaxNbVehicles(address);
    }
    private static native int _getMaxNbVehicles(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbVehicles(int value) {
        checkNotNull();
        _setMaxNbVehicles(address, value);
    }
    private static native void _setMaxNbVehicles(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbWheelsPerVehicle() {
        checkNotNull();
        return _getMaxNbWheelsPerVehicle(address);
    }
    private static native int _getMaxNbWheelsPerVehicle(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbWheelsPerVehicle(int value) {
        checkNotNull();
        _setMaxNbWheelsPerVehicle(address, value);
    }
    private static native void _setMaxNbWheelsPerVehicle(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbHitPointsPerWheel() {
        checkNotNull();
        return _getMaxNbHitPointsPerWheel(address);
    }
    private static native int _getMaxNbHitPointsPerWheel(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbHitPointsPerWheel(int value) {
        checkNotNull();
        _setMaxNbHitPointsPerWheel(address, value);
    }
    private static native void _setMaxNbHitPointsPerWheel(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNumWorkers() {
        checkNotNull();
        return _getNumWorkers(address);
    }
    private static native int _getNumWorkers(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNumWorkers(int value) {
        checkNotNull();
        _setNumWorkers(address, value);
    }
    private static native void _setNumWorkers(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getBatchSize() {
        checkNotNull();
        return _getBatchSize(address);
    }
    private static native int _getBatchSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setBatchSize(int value) {
        checkNotNull();
        _setBatchSize(address, value);
    }
    private static native void _setBatchSize(long address, int value);

    /**
     * @return WebIDL type: {@link PxBatchQueryPreFilterShader} [Value]
     */
    public PxBatchQueryPreFilterShader getPreFilterShader() {
        checkNotNull();
        return PxBatchQueryPreFilterShader.wrapPointer(_getPreFilterShader(address));
    }
    private static native long _getPreFilterShader(long address);

    /**
     * @param value WebIDL type: {@link PxBatchQueryPreFilterShader} [Value]
     */
    public void setPreFilterShader(PxBatchQueryPreFilterShader value) {
        checkNotNull();
        _setPreFilterShader(address, (value != null ? value.getAddress() : 0L));
    }
    private static native void _setPreFilterShader(long address, long value);

    /**
     * @return WebIDL type: {@link PxBatchQueryPostFilterShader} [Value]
     */
    public PxBatchQueryPostFilterShader getPostFilterShader() {
        checkNotNull();
        return PxBatchQueryPostFilterShader.wrapPointer(_getPostFilterShader(address));
    }
    private static native long _getPostFilterShader(long address);

    /**
     * @param value WebIDL type: {@link PxBatchQueryPostFilterShader} [Value]
     */
    public void setPostFilterShader(PxBatchQueryPostFilterShader value) {
        checkNotNull();
        _setPostFilterShader(address, (value != null ? value.getAddress() : 0L));
    }
    private static native void _setPostFilterShader(long address, long value);

}
