package physx.common;

import physx.NativeObject;

public class PxCudaContextManagerDesc extends NativeObject {

    public static PxCudaContextManagerDesc wrapPointer(long address) {
        return address != 0L ? new PxCudaContextManagerDesc(address) : null;
    }
    
    protected PxCudaContextManagerDesc(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxCudaContextManagerDesc
     */
    public static PxCudaContextManagerDesc createAt(long address) {
        __placement_new_PxCudaContextManagerDesc(address);
        PxCudaContextManagerDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxCudaContextManagerDesc
     */
    public static <T> PxCudaContextManagerDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxCudaContextManagerDesc(address);
        PxCudaContextManagerDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxCudaContextManagerDesc(long address);

    // Constructors

    public PxCudaContextManagerDesc() {
        address = _PxCudaContextManagerDesc();
    }
    private static native long _PxCudaContextManagerDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getGraphicsDevice() {
        checkNotNull();
        return NativeObject.wrapPointer(_getGraphicsDevice(address));
    }
    private static native long _getGraphicsDevice(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setGraphicsDevice(NativeObject value) {
        checkNotNull();
        _setGraphicsDevice(address, value.getAddress());
    }
    private static native void _setGraphicsDevice(long address, long value);

    /**
     * @return WebIDL type: {@link PxCudaInteropModeEnum} [enum]
     */
    public int getInteropMode() {
        checkNotNull();
        return _getInteropMode(address);
    }
    private static native int _getInteropMode(long address);

    /**
     * @param value WebIDL type: {@link PxCudaInteropModeEnum} [enum]
     */
    public void setInteropMode(int value) {
        checkNotNull();
        _setInteropMode(address, value);
    }
    private static native void _setInteropMode(long address, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getMaxMemorySize(int index) {
        checkNotNull();
        return _getMaxMemorySize(address, index);
    }
    private static native int _getMaxMemorySize(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setMaxMemorySize(int index, int value) {
        checkNotNull();
        _setMaxMemorySize(address, index, value);
    }
    private static native void _setMaxMemorySize(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getMemoryBaseSize(int index) {
        checkNotNull();
        return _getMemoryBaseSize(address, index);
    }
    private static native int _getMemoryBaseSize(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setMemoryBaseSize(int index, int value) {
        checkNotNull();
        _setMemoryBaseSize(address, index, value);
    }
    private static native void _setMemoryBaseSize(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getMemoryPageSize(int index) {
        checkNotNull();
        return _getMemoryPageSize(address, index);
    }
    private static native int _getMemoryPageSize(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setMemoryPageSize(int index, int value) {
        checkNotNull();
        _setMemoryPageSize(address, index, value);
    }
    private static native void _setMemoryPageSize(long address, int index, int value);

}
